/*!\file: CreateParametersDiagnosticHoriz.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersDiagnosticHoriz"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void CreateParametersDiagnosticHoriz(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* ug=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
//	if (!iomodel->ismacayealpattyn)return;

	/*Get vx and vy: */
	IoModelFetchData((void**)&vx,NULL,NULL,iomodel_handle,"vx","Matrix","Mat");
	IoModelFetchData((void**)&vy,NULL,NULL,iomodel_handle,"vy","Matrix","Mat");
	IoModelFetchData((void**)&vz,NULL,NULL,iomodel_handle,"vz","Matrix","Mat");

	ug=(double*)xcalloc(iomodel->numberofnodes*3,sizeof(double));

	if(vx) for(i=0;i<iomodel->numberofnodes;i++)ug[3*i+0]=vx[i]/iomodel->yts;
	if(vy) for(i=0;i<iomodel->numberofnodes;i++)ug[3*i+1]=vy[i]/iomodel->yts;
	if(vz) for(i=0;i<iomodel->numberofnodes;i++)ug[3*i+2]=vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(ug,3*iomodel->numberofnodes,3);
	parameters->AddObject(param);

	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&ug);
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
