#!/bin/bash
set -eu

#WARNING: make sure you have the right mpi:
#mpi-selector --query
#default:openmpi_intel-1.5.4_psm

#Some cleanup
rm -rf install petsc-3.5.1 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.5.1.tar.gz' 'petsc-3.5.1.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.5.1.tar.gz
mv petsc-3.5.1/* src/
rm -rf petsc-3.5.1

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-blas-lapack-dir="/opt/intel/mkl/10.2.4.032/" \
 --with-mpi-dir="/sopt/mpi/openmpi-1.5.4_psm/intel/" \
 --known-mpi-shared-libraries=1 \
 --with-debugging=0 \
 --with-valgrind=0 \
 --with-batch=1  \
 --with-shared-libraries=1 \
 --download-metis=1 \
 --download-parmetis=1 \
 --download-scalapack=1 \
 --download-mumps=1 \
 --COPTFLAGS="-lmpi -O3" \
 --FOPTFLAGS="-lmpi -O3" \
 --CXXOPTFLAGS="-lmpi -O3"

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l nodes=1:ppn=1
#PBS -q c6145
#PBS -l walltime=10

cd $(echo $ISSM_DIR)/externalpackages/petsc/src/
mpiexec -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
