function prepare_gl(md,options)

%scripts to be picked up from directory:
scriptsdir=['~/issm-projects/visl/externalicelab/fem'];
if strcmpi(md.mesh.hemisphere','s'),
	triangulation='/Users/larour/ModelData/BamberDEMAntarctica1km/triangulated/triangulation_2.mat';
	radar_image='/Users/larour/ModelData/BamberDEMAntarctica1km/triangulated/radar.png';
	triangulation_hd='/Users/larour/ModelData/BamberDEMAntarctica1km/triangulated/triangulation_2.mat';
	geotiff_name_hd=['/u/astrid-r1b/ModelData/MosaicTiffRsat/amm125m_v2_200m.tif'];
elseif strcmpi(md.mesh.hemisphere','n'),
	triangulation='/u/astrid-r1b/ModelData/HowatDEMGreenland2012/triangulated/triangulation_15.mat';
	radar_image='/u/astrid-r1b/ModelData/HowatDEMGreenland2012/triangulated/radar.png';
	triangulation_hd='/u/astrid-r1b/ModelData/HowatDEMGreenland2012/triangulated/triangulation_2.mat';
else
	error('prepare_gl error usage: ''hemisphere'' should be set to ''s'' or ''n''');
end

%keep present directory: 
presentdir=pwd;

%Setup unique directory in present dir: 
directory=getfieldvalue(options,'webpagename','.webgl');
mkdir(directory);
cd(directory);

%Copy scripts needed:
copyfile([scriptsdir '/css'],'./css');
copyfile([scriptsdir '/../css/main.css'],'./css');
copyfile([scriptsdir '/images'],'./images');
copyfile([scriptsdir '/obj'],'./obj');
copyfile([scriptsdir '/src'],'./src');
copyfile([scriptsdir '/js'],'./js');
copyfile([scriptsdir '/generic'],'./generic');
copyfile([scriptsdir '/generic.html'],'.');


database=['./generic/'];

%Write triangulation to disk {{{
tr=load(triangulation);

%write x0, x1, y0 and y1
fid=fopen([database '/image_coords.js'],'w');
fprintf(fid,'var x0=%g;\n',tr.x0);
fprintf(fid,'var x1=%g;\n',tr.x1);
fprintf(fid,'var y0=%g;\n',tr.y0);
fprintf(fid,'var y1=%g;\n',tr.y1);
fclose(fid);

%copy image locally: 
system(['cp ' radar_image ' ' database '/radar.png']);
	
%write triangulation and surface to disk: 
fid=fopen([database '/surface_triangulation.js'],'w');

%write index:
fprintf(fid,'<!-- index_surface{{{-->\n');
fprintf(fid,'var index_surface=[');
for i=1:length(tr.index)-1,
	fprintf(fid,'[%i, %i, %i],',tr.index(i,1),tr.index(i,2),tr.index(i,3));
end
fprintf(fid,'[%i, %i, %i]];\n',tr.index(end,1),tr.index(end,2),tr.index(end,3));
fprintf(fid,'<!--}}}-->\n');
%write x:
fprintf(fid,'<!-- x_surface{{{-->\n');
fprintf(fid,'var x_surface=[');
for i=1:length(tr.x)-1,
	fprintf(fid,'%g,',tr.x(i,1));
end
fprintf(fid,'%g];\n',tr.x(end,1));
fprintf(fid,'<!--}}}-->\n');

%write y:
fprintf(fid,'<!-- y_surface{{{-->\n');
fprintf(fid,'var y_surface=[');
for i=1:length(tr.y)-1,
	fprintf(fid,'%g,',tr.y(i,1));
end
fprintf(fid,'%g];\n',tr.y(end,1));
fprintf(fid,'<!--}}}-->\n');

%write surface:
fprintf(fid,'<!-- surface_surface{{{-->\n');
fprintf(fid,'var surface_surface=[');
for i=1:length(tr.surface)-1,
	fprintf(fid,'%g,',tr.surface(i));
end
fprintf(fid,'%g];\n',tr.surface(end));
fprintf(fid,'<!--}}}-->\n');

fclose(fid);
%}}}
%Write high-res triangulation to disk  {{{
if getfieldvalue(options,'highres',0);
	
	x0=min(md.mesh.x);
	x1=max(md.mesh.x);
	y0=min(md.mesh.y);
	y1=max(md.mesh.y);
	dx=x1-x0;
	dy=y1-y0;
	factor=.25;

	x0=x0-factor*dx;
	x1=x1+factor*dx;
	y1=y1+factor*dy;
	y0=y0-factor*dy;

	%write x0, x1, y0 and y1
	fid=fopen([database '/image_coords_highdef.js'],'w');
	fprintf(fid,'var x0_hd=%g;\n',x0);
	fprintf(fid,'var x1_hd=%g;\n',x1);
	fprintf(fid,'var y0_hd=%g;\n',y0);
	fprintf(fid,'var y1_hd=%g;\n',y1);
	fclose(fid);


	%extract image
	eval(['!gdal_translate -quiet -projwin ' num2str(x0) ' ' num2str(y1) ' ' num2str(x1) ' ' num2str(y0) ' ' geotiff_name_hd ' radar_hd.tif']);

	%convert to png: 
	system('convert radar_hd.tif radar_hd.png  && rm -rf radar_hd.tif');

	%get width: 
	[status,width]=system(['convert radar_hd.png -format %w info:']); width=str2num(width);

	%get height: 
	[status,height]=system(['convert radar_hd.png -format %h info:']); height=str2num(height);

	%get these a power of 2: 
	width=2^(nextpow2(width));
	height=2^(nextpow2(height));

	%change size of image: 
	system(['convert -geometry ' num2str(width) 'x' num2str(height) '! radar_hd.png radar_hd.png']);

	system(['mv radar_hd.png ' database '/radar_hd.png']);

	%now, extract higher resolution triangulation:
	trhd=load(triangulation_hd); a=trhd;
	trhd.xelem=trhd.x(trhd.index)*[1;1;1]/3;
	trhd.yelem=trhd.y(trhd.index)*[1;1;1]/3;
	
	pos_elem=find(x0<=trhd.xelem & trhd.xelem<=x1 & y0<=trhd.yelem & trhd.yelem<=y1);
	pos_node=sort(unique(trhd.index(pos_elem,:)));

	%keep track of some fields
	numberofvertices1=length(trhd.x);
	numberofelements1=length(trhd.index);
	numberofvertices2=length(pos_node);
	numberofelements2=length(pos_elem);
	flag_node=zeros(numberofvertices1,1);
	flag_node(pos_node)=1;

	%Create Pelem and Pnode (transform old nodes in new nodes and same thing for the elements)
	Pelem=zeros(numberofelements1,1);
	Pelem(pos_elem)=[1:numberofelements2]';
	Pnode=zeros(numberofvertices1,1);
	Pnode(pos_node)=[1:numberofvertices2]';

	%renumber the elements (some nodes won't exist anymore)
	index2=trhd.index(pos_elem,:);
	index2(:,1)=Pnode(index2(:,1));
	index2(:,2)=Pnode(index2(:,2));
	index2(:,3)=Pnode(index2(:,3));

	trhd.index=index2;
	trhd.x=trhd.x(pos_node);
	trhd.y=trhd.y(pos_node);
	trhd.surface=trhd.surface(pos_node);

	%write triangulation and surface to disk: 
	fid=fopen([database '/surface_triangulation_hd.js'],'w');

	%write index:
	fprintf(fid,'<!-- index_surface_hd{{{-->\n');
	fprintf(fid,'var index_surface_hd=[');
	for i=1:length(trhd.index)-1,
		fprintf(fid,'[%i, %i, %i],',trhd.index(i,1),trhd.index(i,2),trhd.index(i,3));
	end
	fprintf(fid,'[%i, %i, %i]];\n',trhd.index(end,1),trhd.index(end,2),trhd.index(end,3));
	fprintf(fid,'<!--}}}-->\n');
	%write x:
	fprintf(fid,'<!-- x_surface_hd{{{-->\n');
	fprintf(fid,'var x_surface_hd=[');
	for i=1:length(trhd.x)-1,
		fprintf(fid,'%g,',trhd.x(i,1));
	end
	fprintf(fid,'%g];\n',trhd.x(end,1));
	fprintf(fid,'<!--}}}-->\n');

	%write y:
	fprintf(fid,'<!-- y_surface_hd{{{-->\n');
	fprintf(fid,'var y_surface_hd=[');
	for i=1:length(trhd.y)-1,
		fprintf(fid,'%g,',trhd.y(i,1));
	end
	fprintf(fid,'%g];\n',trhd.y(end,1));
	fprintf(fid,'<!--}}}-->\n');

	%write surface:
	fprintf(fid,'<!-- surface_surface_hd{{{-->\n');
	fprintf(fid,'var surface_surface_hd=[');
	for i=1:length(trhd.surface)-1,
		fprintf(fid,'%g,',trhd.surface(i));
	end
	fprintf(fid,'%g];\n',trhd.surface(end));
	fprintf(fid,'<!--}}}-->\n');

	fclose(fid);
	a2=trhd;
	save temp2 a2 a
else
	delete([database '/radar_hd.png']);
	delete([database '/image_coords_highdef.js']);
	delete([database '/surface_triangulation_hd.js']);
	
end
% }}}
%Deal with contour {{{
	
	fid=fopen([database '/contour_coords.js'],'w');

	contour_x=md.mesh.x(md.mesh.segments(:,1));
	contour_y=md.mesh.y(md.mesh.segments(:,1));
	contour_surface=md.geometry.surface(md.mesh.segments(:,1));

	%write contour_x:
	fprintf(fid,'<!-- contour_x{{{-->\n');
	fprintf(fid,'var contour_x=[');
	for i=1:length(contour_x)-1,
		fprintf(fid,'%g,',contour_x(i));
	end
	fprintf(fid,'%g];\n',contour_x(end));
	fprintf(fid,'<!--}}}-->\n');

	%write contour_y:
	fprintf(fid,'<!-- contour_y{{{-->\n');
	fprintf(fid,'var contour_y=[');
	for i=1:length(contour_y)-1,
		fprintf(fid,'%g,',contour_y(i));
	end
	fprintf(fid,'%g];\n',contour_y(end));
	fprintf(fid,'<!--}}}-->\n');

	%write contour_surface:
	fprintf(fid,'<!-- contour_surface{{{-->\n');
	fprintf(fid,'var contour_surface=[');
	for i=1:length(contour_surface)-1,
		fprintf(fid,'%g,',contour_surface(i));
	end
	fprintf(fid,'%g];\n',contour_surface(end));
	fprintf(fid,'<!--}}}-->\n');

	fclose(fid);
% }}}

%Come back to present directory: 
cd(presentdir);
