function plotgl(md,optionslist)
scriptsdir=['~/issm-projects/visl/externalicelab/fem'];

%check on existing of webgl directory: 
if ~exist('.webgl','dir'),
	prepare_gl(md,checkplotoptions(md,optionslist{1}));
end
	
options=optionslist{1};
options=checkplotoptions(md,options);

%keep present directory: 
presentdir=pwd;

%Setup unique directory in present dir: 
directory=getfieldvalue(options,'webpagename','.webgl');
database=['./generic/'];
cd(directory);

%copy editables.js file
copyfile([scriptsdir '/generic/editables.js'],'./generic/editables.js');

%Deal with title: 
if exist(options,'title')
	title=getfieldvalue(options,'title');
else
	title='';
end
replacestringinfile('./generic/editables.js','Generic Plot',title);

%height scaling:
replacestringinfile('./generic/editables.js','var height_scaling = 60.0;',['var height_scaling = ' num2str(getfieldvalue(options,'height_scaling',60)) ';']);

%size of frame: 
replacestringinfile('./css/mystyle.css','height: 55%; /*editable*/',['height: ' num2str(getfieldvalue(options,'frame_height',55)) '%; /*editable*/']);

%high resolution: 
if ~getfieldvalue(options,'highres',0);
	replacestringinfile('./generic/editables.js','var hdBackgroundImageFileName = experiment_name + "/radar_hd.png";','var hdBackgroundImageFileName = "";');
end

%ocean zero threshold: 
replacestringinfile('./generic/editables.js','var ocean_threshold = .001;',['var ocean_threshold = ' num2str(getfieldvalue(options,'ocean_threshold',.001)) ';']);

%intial view angle: 
replacestringinfile('./generic/editables.js','var view_number_default = 3;',['var view_number_default = ' num2str(getfieldvalue(options,'view_number_default',3)) ';']);

%Deal with mesh and results {{{
	
	fid=fopen([database 'model_coords.js'],'w');

	%write index:
	fprintf(fid,'<!-- index{{{-->\n');
	fprintf(fid,'var index=[');
	for i=1:md.mesh.numberofelements-1,
		fprintf(fid,'[%i, %i, %i],',md.mesh.elements(i,1),md.mesh.elements(i,2),md.mesh.elements(i,3));
	end
	fprintf(fid,'[%i, %i, %i]];\n',md.mesh.elements(end,1),md.mesh.elements(end,2),md.mesh.elements(end,3));
	fprintf(fid,'<!--}}}-->\n');
	writejsfield(fid,'x',md.mesh.x,md.mesh.numberofvertices);
	writejsfield(fid,'y',md.mesh.y,md.mesh.numberofvertices);
	writejsfield(fid,'surface',md.geometry.surface,md.mesh.numberofvertices);

	%Deal with data: 
	datastring='';
	caxis1string='';
	caxis2string='';
	labelstring='';
	unitstring='';
	zoom=getfieldvalue(options,'zoom',-.25);
	for i=1:length(optionslist),
		options=optionslist{i}; options=checkplotoptions(md,options);
		data=getfieldvalue(options,'data');
		caxis=getfieldvalue(options,'caxis',[min(data(:)) max(data(:))]);
		label=getfieldvalue(options,'label','');
		if strcmpi(label,''),
			%create generic label: 
			label=['data' num2str(i)];
		end
		unit=getfieldvalue(options,'unit','');
		if strcmpi(unit,''),
			%create generic unit: 
			unit='SI';
		end

		if i<length(optionslist),
			datastring=[datastring '"data' num2str(i) '",'];
			caxis1string=[caxis1string num2str(caxis(1)) ','];
			caxis2string=[caxis2string num2str(caxis(2)) ','];
			labelstring=[labelstring '"' label '"' ','];
			unitstring=[unitstring '"' unit '"' ','];
		else
			datastring=[datastring '"data' num2str(i) '"' ];
			caxis1string=[caxis1string num2str(caxis(1))];
			caxis2string=[caxis2string num2str(caxis(2))];
			labelstring=[labelstring '"' label '"'];
			unitstring=[unitstring '"' unit '"'];
		end
		writejsfield(fid,['data' num2str(i)],data,md.mesh.numberofvertices);
	end
	replacestringinfile('./generic/editables.js','"V"',labelstring);
	replacestringinfile('./generic/editables.js','"velocity"',datastring);
	replacestringinfile('./generic/editables.js','var data_min_array = [-9999',['var data_min_array = [' caxis1string]);
	replacestringinfile('./generic/editables.js','var data_max_array = [9999',['var data_max_array = [' caxis2string]);
	replacestringinfile('./generic/editables.js','"m/yr"',unitstring);
	replacestringinfile('./generic/editables.js','initialZoomFactor = -.20;',['initialZoomFactor = ' num2str(zoom) ';']);
	


	fclose(fid);
% }}}

%Open browser with results: 
web('./generic.html','-browser');

%Come back to present directory: 
cd(presentdir);
