%GROUNDINGLINE class definition
%
%   Usage:
%      groundingline=groundingline();

classdef groundingline
	properties (SetAccess=public) 
		migration    = '';
	end
	methods
         function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- groundingline -->');
            
            % Convergence criteria          
            fprintf(fid,'%s\n%s\n%s\n','<frame key="1" label="Grounding line migration parameters">','<section name="groundingline" />');  
			
            % migration (SoftMigration, AggressiveMigration, or None)drop-down
            fprintf(fid,'%s\n%s\n%s\n%s\n','<parameter key ="migration" type="alternative" optional="false">','     <section name="groundingline" />','     <help> type of grounding line migration: "SoftMigration","AggressiveMigration" or "None" </help>');
            fprintf(fid,'%s\n','       <option value="SoftMigration" type="string" default="true"> </option>');
            fprintf(fid,'%s\n','       <option value="AggressiveMigration" type="string" default="false"> </option>');
            fprintf(fid, '%s\n%s\n','       <option value="None" type="string" default="false"></option>','</parameter>');

            fprintf(fid,'%s\n%s\n','</frame>');
        end % }}}
		function obj = groundingline(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%Type of migration
			obj.migration='None';

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','groundingline.migration','values',{'None' 'AggressiveMigration' 'SoftMigration' 'SubelementMigration' 'SubelementMigration2' 'Contact' 'None'});

			if ~strcmp(obj.migration,'None'),
				if isnan(md.geometry.bed),
					md = checkmessage(md,['requesting grounding line migration, but bathymetry is absent!']);
				end
				pos=find(md.mask.groundedice_levelset>0.);
				if any(abs(md.geometry.base(pos)-md.geometry.bed(pos))>10^-10),
					md = checkmessage(md,['baase not equal to bed on grounded ice!']);
				end
				if any(md.geometry.bed - md.geometry.base > 10^-9),
					md = checkmessage(md,['bed superior to base on floating ice!']);
				end
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   grounding line migration parameters:'));
			fielddisplay(obj,'migration','type of grounding line migration: ''SoftMigration'',''AggressiveMigration'' or ''None''');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'data',StringToEnum(obj.migration),'enum',GroundinglineMigrationEnum(),'format','Integer');
		end % }}}
	end
end
