import numpy 
from triangle import triangle
from model import model
from setmask import setmask
from parameterize import parameterize
from verbose import verbose
from setflowequation import setflowequation
from generic import generic
from socket import gethostname as oshostname
from solve import solve
from EnumDefinitions import DamageEvolutionSolutionEnum
from matdamageice import matdamageice

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'all','')
md.materials=matdamageice()
md=parameterize(md,'../Par/SquareShelf.py')
md.damage.isdamage=1
md.damage.D=numpy.zeros(md.mesh.numberofvertices)
md.damage.spcdamage=numpy.nan*numpy.ones(md.mesh.numberofvertices)
md.damage.law=1
md.damage.stabilization=1;

pos=numpy.nonzero(numpy.logical_and(md.mask.ice_levelset!=0,md.mesh.vertexonboundary==1))
md.damage.spcdamage[pos]=0.5;

md.damage.requested_outputs=['default','DamageF']

md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DamageEvolutionSolutionEnum())

field_names=['D','F']
field_tolerances=[1.e-13,1.e-13]
field_values=[\
		md.results.DamageEvolutionSolution.DamageDbar,\
		md.results.DamageEvolutionSolution.DamageF,\
		]
