%BALANCETHICKNESS2 class definition
%
%   Usage:
%      balancethickness2=balancethickness2();

classdef balancethickness2
	properties (SetAccess=public) 
		spcpotential         = NaN;
		apparent_massbalance = NaN;
		nux                  = NaN;
		nuy                  = NaN;
		vx_obs               = NaN;
		vy_obs               = NaN;
		thickness_obs        = NaN;
	end
	methods
		function obj = balancethickness2(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%Early return
			if solution~=Balancethickness2SolutionEnum(), return; end

			md = checkfield(md,'fieldname','balancethickness.spcpotential','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','balancethickness.apparent_massbalance','size',[md.mesh.numberofvertices 1],'NaN',1);
			md = checkfield(md,'fieldname','balancethickness.nux','size',[md.mesh.numberofvertices 1],'NaN',1,'>',0,'<=',1);
			md = checkfield(md,'fieldname','balancethickness.nuy','size',[md.mesh.numberofvertices 1],'NaN',1,'>',0,'<=',1);
			md = checkfield(md,'fieldname','balancethickness.vx_obs','size',[md.mesh.numberofvertices 1],'NaN',1);
			md = checkfield(md,'fieldname','balancethickness.vy_obs','size',[md.mesh.numberofvertices 1],'NaN',1);
			md = checkfield(md,'fieldname','balancethickness.thickness_obs','size',[md.mesh.numberofvertices 1],'NaN',1,'>=',0);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   balance thickness solution parameters:'));

			fielddisplay(obj,'spcpotential','potential constraints (NaN means no constraint)');
			fielddisplay(obj,'apparent_massbalance','Apparent mass balance [m/yr]');
			fielddisplay(obj,'nux','vx_bar = nux vx_s (in ]0 1])');
			fielddisplay(obj,'nuy','vy_bar = nuy vy_s (in ]0 1])');
			fielddisplay(obj,'vx_obs','observed vx');
			fielddisplay(obj,'vy_obs','observed vy');
			fielddisplay(obj,'thickness_obs','observed H');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'class','Balancethickness','fieldname','spcpotential','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'class','Balancethickness','fieldname','apparent_massbalance','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'class','Balancethickness','fieldname','nux','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'class','Balancethickness','fieldname','nuy','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'class','Balancethickness','fieldname','vx_obs','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'class','Balancethickness','fieldname','vy_obs','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'class','Balancethickness','fieldname','thickness_obs','format','DoubleMat','mattype',1);
		end % }}}
	end
end
