/*! \file StressbalanceAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _StressbalanceAnalysis_
#define _StressbalanceAnalysis_

/*Headers*/
#include "./Analysis.h"

class StressbalanceAnalysis: public Analysis{

  public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int domaintype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		void           Core(FemModel* femmodel);
		ElementVector* CreateDVector(Element* element);
		ElementMatrix* CreateJacobianMatrix(Element* element);
		ElementMatrix* CreateKMatrix(Element* element);
		ElementVector* CreatePVector(Element* element);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index);
		void GetSolutionFromInputsHoriz(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void UpdateConstraints(FemModel* femmodel);

		/*SSA*/
		ElementMatrix* CreateJacobianMatrixSSA(Element* element);
		ElementMatrix* CreateKMatrixSSA(Element* element);
		ElementMatrix* CreateKMatrixSSAViscous(Element* element);
		ElementMatrix* CreateKMatrixSSAFriction(Element* element);
		ElementMatrix* CreateKMatrixSSALateralFriction(Element* element);
		ElementVector* CreatePVectorSSA(Element* element);
		ElementVector* CreatePVectorSSADrivingStress(Element* element);
		ElementVector* CreatePVectorSSAFront(Element* element);
		void GetBSSA(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBSSAprime(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBSSAFriction(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void InputUpdateFromSolutionSSA(IssmDouble* solution,Element* element);
		/*L1L2*/
		ElementMatrix* CreateKMatrixL1L2(Element* element);
		ElementMatrix* CreateKMatrixL1L2Viscous(Element* element);
		ElementMatrix* CreateKMatrixL1L2Friction(Element* element);
		ElementVector* CreatePVectorL1L2(Element* element);
		ElementVector* CreatePVectorL1L2DrivingStress(Element* element);
		ElementVector* CreatePVectorL1L2Front(Element* element);
		void InputUpdateFromSolutionL1L2(IssmDouble* solution,Element* element);
		/*HO*/
		ElementMatrix* CreateJacobianMatrixHO(Element* element);
		ElementMatrix* CreateKMatrixHO(Element* element);
		ElementMatrix* CreateKMatrixHOViscous(Element* element);
		ElementMatrix* CreateKMatrixHOFriction(Element* element);
		ElementVector* CreatePVectorHO(Element* element);
		ElementVector* CreatePVectorHODrivingStress(Element* element);
		ElementVector* CreatePVectorHOFront(Element* element);
		void GetBHO(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBHOprime(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBHOFriction(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void InputUpdateFromSolutionHO(IssmDouble* solution,Element* element);
		/*FS*/
		ElementVector* CreateDVectorFS(Element* element);
		ElementMatrix* CreateJacobianMatrixFS(Element* element);
		ElementMatrix* CreateKMatrixFS(Element* element);
		ElementMatrix* CreateKMatrixFSViscousLATH(Element* element);
		ElementMatrix* CreateKMatrixFSViscousXTH(Element* element);
		ElementMatrix* CreateKMatrixFSViscous(Element* element);
		ElementMatrix* CreateKMatrixFSFriction(Element* element);
		ElementMatrix* CreateKMatrixFSShelf(Element* element);
		ElementVector* CreatePVectorFS(Element* element);
		ElementVector* CreatePVectorFSViscous(Element* element);
		ElementVector* CreatePVectorFSViscousLATH(Element* element);
		ElementVector* CreatePVectorFSViscousXTH(Element* element);
		ElementVector* CreatePVectorFSShelf(Element* element);
		ElementVector* CreatePVectorFSFront(Element* element);
		ElementVector* CreatePVectorFSFriction(Element* element);
		ElementVector* CreatePVectorFSStress(Element* element);
		void GetBFS(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBFSprime(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBFSvel(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBFSprimevel(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBFSFriction(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBFSUzawa(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBFSprimeUzawa(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetCFS(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetCFSprime(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetSolutionFromInputsFS(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolutionFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionFSXTH_d(Elements* elements,Parameters* parameters);
		void InputUpdateFromSolutionFSXTH_tau(Elements* elements,Parameters* parameters);
		void InitializeXTH(Elements* elements,Parameters* parameters);
		/*Coupling*/
		ElementMatrix* CreateKMatrixSSA3d(Element* element);
		ElementMatrix* CreateKMatrixSSA3dFriction(Element* element);
		ElementMatrix* CreateKMatrixSSA3dViscous(Element* element);
		ElementMatrix* CreateKMatrixHOFS(Element* element);
		ElementMatrix* CreateKMatrixSSAHO(Element* element);
		ElementMatrix* CreateKMatrixSSAFS(Element* element);
		ElementMatrix* CreateKMatrixCouplingHOFS(Element* element);
		ElementMatrix* CreateKMatrixCouplingSSAHO(Element* element);
		ElementMatrix* CreateKMatrixCouplingSSAHOFriction(Element* element);
		ElementMatrix* CreateKMatrixCouplingSSAHOViscous(Element* element);
		ElementMatrix* CreateKMatrixCouplingSSAFS(Element* element);
		ElementMatrix* CreateKMatrixCouplingSSAFSFriction(Element* element);
		ElementMatrix* CreateKMatrixCouplingSSAFSViscous(Element* element);
		ElementVector* CreatePVectorSSAHO(Element* element);
		ElementVector* CreatePVectorSSAFS(Element* element);
		ElementVector* CreatePVectorCouplingSSAFS(Element* element);
		ElementVector* CreatePVectorCouplingSSAFSFriction(Element* element);
		ElementVector* CreatePVectorCouplingSSAFSViscous(Element* element);
		ElementVector* CreatePVectorHOFS(Element* element);
		ElementVector* CreatePVectorCouplingHOFS(Element* element);
		ElementVector* CreatePVectorCouplingHOFSFriction(Element* element);
		ElementVector* CreatePVectorCouplingHOFSViscous(Element* element);
		void GetBSSAHO(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBSSAFS(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBprimeSSAFS(IssmDouble* Bprime,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBSSAFSTria(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBprimeSSAFSTria(IssmDouble* Bprime,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetLFSSSA(IssmDouble* L,Element* element,Gauss* gauss);
		void GetLSSAFS(IssmDouble* L,Element* element,Gauss* gauss);
		void GetLprimeFSSSA(IssmDouble* Lprime,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetLprimeSSAFS(IssmDouble* Lprime,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void InputUpdateFromSolutionHOFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionSSAFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionSSAHO(IssmDouble* solution,Element* element);
};
#endif
