/*! \file ExtrapolationAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _ExtrapolationAnalysis_
#define _ExtrapolationAnalysis_

/*Headers*/
#include "./Analysis.h"

class ExtrapolationAnalysis: public Analysis{
	
 public:
	/*Model processing*/
	int  DofsPerNode(int** doflist,int domaintype,int approximation);
	void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
	void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
	void CreateNodes(Nodes* nodes,IoModel* iomodel);
	void CreateConstraints(Constraints* constraints,IoModel* iomodel);
	void CreateLoads(Loads* loads, IoModel* iomodel);

	/*Finite element Analysis*/
	void           Core(FemModel* femmodel);
	ElementVector* CreateDVector(Element* element);
	ElementMatrix* CreateJacobianMatrix(Element* element);
	ElementMatrix* CreateKMatrix(Element* element);
	ElementVector* CreatePVector(Element* element);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index);
	void InputUpdateFromSolution(IssmDouble* solution,Element* element);
	void UpdateConstraints(FemModel* femmodel);
	void GetB(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
	void GetBprime(IssmDouble* Bprime,Element* element,IssmDouble* xyz_list,Gauss* gauss);
	void SetConstraintsOnIce(Element* element);
};
#endif
