/*!\file Matice.h
 * \brief: header file for matice object
 */

#ifndef MATICE_H_
#define MATICE_H_

/*Headers:*/
/*{{{*/
#include "./Material.h"
#include "../Hook.h"
class IoModel;
class Elements;
class Element;
class Loads;
class Nodes;
class Vertices;
class Materials;
class Parameters;
/*}}}*/

class Matice: public Material{

	private: 
		int      mid;
		bool     isdamaged;
		Hook    *helement;
		Element *element;

	public:
		/*Matice constructors, destructors: {{{*/
		Matice();
		Matice(int mid,int i, IoModel* iomodel);
		~Matice();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual funictions definitions: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nrow, int ncols, int name, int type);
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void  InputUpdateFromConstant(IssmDouble constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("not implemented");};
		/*}}}*/
		/*Material virtual functions resolution: {{{*/
		void   Configure(Elements* elements);
		Material*  copy2(Element* element);
		void       SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void       GetViscosity(IssmDouble* pviscosity, IssmDouble eps_eff);
		void       GetViscosity_B(IssmDouble* pviscosity, IssmDouble eps_eff);
		void       GetViscosity_D(IssmDouble* pviscosity, IssmDouble eps_eff);
		void       GetViscosityBar(IssmDouble* pviscosity, IssmDouble eps_eff);
		void       GetViscosityComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon);
		void       GetViscosityDComplement(IssmDouble*, IssmDouble*);
		void       GetViscosityDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		void       GetViscosity2dDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		IssmDouble GetA();
		IssmDouble GetAbar();
		IssmDouble GetB();
		IssmDouble GetBbar();
		IssmDouble GetD();
		IssmDouble GetDbar();
		IssmDouble GetN();
		bool       IsDamage();
		void       ResetHooks();
		/*}}}*/
};

#endif  /* _MATICE_H_ */
