function rgbcolorbar(options)
%RGBCOLORBAR - this is a triangular colorbar, three corners representing red=1, green=0, blue=0, 
%  red=0, green=1, blue=0 and red=0, green=0, blue=1. The rest of the triangle is colorbar corresponding to 
%  the r,g,b triple using patch type coloring. We build a triagngular mesh to do this!
%
%   Usage:
%      rgbcolorbar(options)
%
%   See also: PLOTMODEL

	%first, urn classic colorbar off
	colorbar off;

	%create simple triangle mesh: 
	a.x=[0 1 .5 0];
	a.y=[0 0 .5*tand(60) 0];
	a.density=1;
	expwrite(a,'rgbcolor.exp');
	md=triangle(model,'rgbcolor.exp',.005);
	delete rgbcolor.exp

	x1=a.x(1); x2=a.x(2); x3=a.x(3);
	y1=a.y(1); y2=a.y(2); y3=a.y(3);

	x3x1=x1-x3;
	y3y1=y1-y3;
	x3x2=x2-x3;
	y3y2=y2-y3;
	delta=x2*y3-y2*x3-x1*y3+y1*x3+x1*y2-y1*x2;

	r=zeros(md.mesh.numberofvertices,1);
	g=zeros(md.mesh.numberofvertices,1);
	b=zeros(md.mesh.numberofvertices,1);
	
	for i=1:md.mesh.numberofvertices,
		
		x0=md.mesh.x(i);
		y0=md.mesh.y(i);

		%first area coordinate
		r(i)=(y3y2*(x0-x3)-x3x2.*(y0-y3))./delta;
		%second area coordinate
		g(i)=(x3x1.*(y0-y3)-y3y1.*(x0-x3))./delta;
		%third area coordinate
		b(i)=1-r(i)-g(i);
	end
	
	%keep handle to current axes before creating one.
	current=gca;

	%now position a patch: 
	position=getfieldvalue(options,'colorbarpos',[.9 .3 .1 .1]);
	axes('position',position);
	t=patch( 'Faces', [md.mesh.elements(:,1) md.mesh.elements(:,2) md.mesh.elements(:,3)], 'Vertices', [md.mesh.x md.mesh.y zeros(md.mesh.numberofvertices,1)],'FaceVertexCData', [r g b], 'FaceColor','interp','EdgeColor','none');axis square off;

	%deal wih titles: 
	titles=getfieldvalue(options,'colorbartitle',{'','',''});
	fontsize=getfieldvalue(options,'fontsize',12);

	text(x1,y1-.1,titles{1},'FontSize',fontsize);
	text(x2-.1,y2-.1,titles{2},'FontSize',fontsize);
	text(x3,y3+.05,titles{3},'FontSize',fontsize);

	%reestablish axes
	axes(current);
