function prepare_gl(md,options)

%scripts to be picked up from directory:
scriptsdir=['~/issm-projects/visl/externalicelab/fem'];
if strcmpi(md.mesh.hemisphere','s'),
	triangulation='/Users/larour/ModelData/BamberDEMAntarctica1km/triangulated/triangulation_15.mat';
	radar_image='/Users/larour/ModelData/BamberDEMAntarctica1km/triangulated/radar.png';
elseif strcmpi(md.mesh.hemisphere','n'),
	triangulation='/u/astrid-r1b/ModelData/HowatDEMGreenland2012/triangulated/triangulation_15.mat';
	radar_image='/u/astrid-r1b/ModelData/HowatDEMGreenland2012/triangulated/radar.png';
else
	error('prepare_gl error usage: ''hemisphere'' should be set to ''s'' or ''n''');
end

%keep present directory: 
presentdir=pwd;

%Setup unique directory in present dir: 
directory='.webgl';
mkdir(directory);
cd(directory);

%Copy scripts needed:
copyfile([scriptsdir '/css'],'./css');
copyfile([scriptsdir '/../css/main.css'],'./css');
copyfile([scriptsdir '/images'],'./images');
copyfile([scriptsdir '/obj'],'./obj');
copyfile([scriptsdir '/src'],'./src');
copyfile([scriptsdir '/js'],'./js');
copyfile([scriptsdir '/generic'],'./generic');
copyfile([scriptsdir '/generic.html'],'.');


database=['./generic/'];

%Write triangulation to disk {{{
tr=load(triangulation);

%write x0, x1, y0 and y1
fid=fopen([database '/image_coords.js'],'w');
fprintf(fid,'var x0=%g;\n',tr.x0);
fprintf(fid,'var x1=%g;\n',tr.x1);
fprintf(fid,'var y0=%g;\n',tr.y0);
fprintf(fid,'var y1=%g;\n',tr.y1);
fclose(fid);

%copy image locally: 
system(['cp ' radar_image ' ' database '/radar.png']);
	
%write triangulation and surface to disk: 
fid=fopen([database '/surface_triangulation.js'],'w');

%write index:
fprintf(fid,'<!-- index_surface{{{-->\n');
fprintf(fid,'var index_surface=[');
for i=1:length(tr.index)-1,
	fprintf(fid,'[%i, %i, %i],',tr.index(i,1),tr.index(i,2),tr.index(i,3));
end
fprintf(fid,'[%i, %i, %i]];\n',tr.index(end,1),tr.index(end,2),tr.index(end,3));
fprintf(fid,'<!--}}}-->\n');
%write x:
fprintf(fid,'<!-- x_surface{{{-->\n');
fprintf(fid,'var x_surface=[');
for i=1:length(tr.x)-1,
	fprintf(fid,'%g,',tr.x(i,1));
end
fprintf(fid,'%g];\n',tr.x(end,1));
fprintf(fid,'<!--}}}-->\n');

%write y:
fprintf(fid,'<!-- y_surface{{{-->\n');
fprintf(fid,'var y_surface=[');
for i=1:length(tr.y)-1,
	fprintf(fid,'%g,',tr.y(i,1));
end
fprintf(fid,'%g];\n',tr.y(end,1));
fprintf(fid,'<!--}}}-->\n');

%write surface:
fprintf(fid,'<!-- surface_surface{{{-->\n');
fprintf(fid,'var surface_surface=[');
for i=1:length(tr.surface)-1,
	fprintf(fid,'%g,',tr.surface(i));
end
fprintf(fid,'%g];\n',tr.surface(end));
fprintf(fid,'<!--}}}-->\n');

fclose(fid);
%}}}
%Write high-res Greenland triangulation to disk  {{{
if getfieldvalue(options,'highres',0);
	x0=min(md.mesh.x);
	x1=max(md.mesh.x);
	y0=min(md.mesh.y);
	y1=max(md.mesh.y);
	dx=x1-x0;
	dy=y1-y0;
	factor=.25;

	x0=x0-factor*dx;
	x1=x1+factor*dx;
	y1=y1+factor*dy;
	y0=y0-factor*dy;

	%write x0, x1, y0 and y1
	fid=fopen([database '/image_coords_highdef.js'],'w');
	fprintf(fid,'var x0_hd=%g;\n',x0);
	fprintf(fid,'var x1_hd=%g;\n',x1);
	fprintf(fid,'var y0_hd=%g;\n',y0);
	fprintf(fid,'var y1_hd=%g;\n',y1);
	fclose(fid);


	%extract image
	eval(['!gdal_translate -quiet -projwin ' num2str(x0) ' ' num2str(y1) ' ' num2str(x1) ' ' num2str(y0) ' ' geotiff_name_hd ' radar_hd.tif']);

	%convert to png: 
	system('convert radar_hd.tif radar_hd.png  && rm -rf radar_hd.tif');

	%get width: 
	[status,width]=system(['convert radar_hd.png -format %w info:']); width=str2num(width);

	%get height: 
	[status,height]=system(['convert radar_hd.png -format %h info:']); height=str2num(height);

	%get these a powers of 2: 
	width=2^(nextpow2(width));
	height=2^(nextpow2(height));

	%change size of image: 
	system(['convert -geometry ' num2str(width) 'x' num2str(height) '! radar_hd.png radar_hd.png']);

	system(['mv radar_hd.png ' database '/radar_hd.png']);

	%create square mesh initially: 
	md_temp=squaremesh(model,1,1,100,100);

	%scale:
	md_temp.mesh.x=x0+md_temp.mesh.x*(x1-x0);
	md_temp.mesh.y=y0+md_temp.mesh.y*(y1-y0);

	%now refine to better capture surface:
	hmax=500000;
	hmin=500;
	err=2;
	sobs=InterpFromGridToMesh(x_m,y_m,surface,md_temp.mesh.x,md_temp.mesh.y,0);
	md_temp=bamg(md_temp,'hmax',hmax,'hmin',hmin,'gradation',10,'field',sobs,'err',err,'splitcorner',1,'KeepVertices',0);
	sobs=InterpFromGridToMesh(x_m,y_m,surface,md_temp.mesh.x,md_temp.mesh.y,0);

	%write triangulation and surface to disk: 
	fid=fopen([database '/surface_triangulation_hd.js'],'w');

	%write index:
	fprintf(fid,'<!-- index_surface_hd{{{-->\n');
	fprintf(fid,'var index_surface_hd=[');
	for i=1:md_temp.mesh.numberofelements-1,
		fprintf(fid,'[%i, %i, %i],',md_temp.mesh.elements(i,1),md_temp.mesh.elements(i,2),md_temp.mesh.elements(i,3));
	end
	fprintf(fid,'[%i, %i, %i]];\n',md_temp.mesh.elements(end,1),md_temp.mesh.elements(end,2),md_temp.mesh.elements(end,3));
	fprintf(fid,'<!--}}}-->\n');
	%write x:
	fprintf(fid,'<!-- x_surface_hd{{{-->\n');
	fprintf(fid,'var x_surface_hd=[');
	for i=1:md_temp.mesh.numberofvertices-1,
		fprintf(fid,'%g,',md_temp.mesh.x(i,1));
	end
	fprintf(fid,'%g];\n',md_temp.mesh.x(end,1));
	fprintf(fid,'<!--}}}-->\n');

	%write y:
	fprintf(fid,'<!-- y_surface_hd{{{-->\n');
	fprintf(fid,'var y_surface_hd=[');
	for i=1:md_temp.mesh.numberofvertices-1,
		fprintf(fid,'%g,',md_temp.mesh.y(i,1));
	end
	fprintf(fid,'%g];\n',md_temp.mesh.y(end,1));
	fprintf(fid,'<!--}}}-->\n');

	%write surface:
	fprintf(fid,'<!-- surface_surface_hd{{{-->\n');
	fprintf(fid,'var surface_surface_hd=[');
	for i=1:md_temp.mesh.numberofvertices-1,
		fprintf(fid,'%g,',sobs(i));
	end
	fprintf(fid,'%g];\n',sobs(end));
	fprintf(fid,'<!--}}}-->\n');

	fclose(fid);
else
	delete([database '/radar_hd.png']);
	delete([database '/image_coords_highdef.js']);
	delete([database '/surface_triangulation_hd.js']);
	
end
% }}}
%Deal with contour {{{
	
	fid=fopen([database '/contour_coords.js'],'w');

	contour_x=md.mesh.x(md.mesh.segments(:,1));
	contour_y=md.mesh.y(md.mesh.segments(:,1));
	contour_surface=md.geometry.surface(md.mesh.segments(:,1));

	%write contour_x:
	fprintf(fid,'<!-- contour_x{{{-->\n');
	fprintf(fid,'var contour_x=[');
	for i=1:length(contour_x)-1,
		fprintf(fid,'%g,',contour_x(i));
	end
	fprintf(fid,'%g];\n',contour_x(end));
	fprintf(fid,'<!--}}}-->\n');

	%write contour_y:
	fprintf(fid,'<!-- contour_y{{{-->\n');
	fprintf(fid,'var contour_y=[');
	for i=1:length(contour_y)-1,
		fprintf(fid,'%g,',contour_y(i));
	end
	fprintf(fid,'%g];\n',contour_y(end));
	fprintf(fid,'<!--}}}-->\n');

	%write contour_surface:
	fprintf(fid,'<!-- contour_surface{{{-->\n');
	fprintf(fid,'var contour_surface=[');
	for i=1:length(contour_surface)-1,
		fprintf(fid,'%g,',contour_surface(i));
	end
	fprintf(fid,'%g];\n',contour_surface(end));
	fprintf(fid,'<!--}}}-->\n');

	fclose(fid);
% }}}

%Come back to present directory: 
cd(presentdir);
