if any(steps==8)
	disp('   Step 8: Plotting exercise');

	%load historic transient model
	md = loadmodel('./Models/Greenland.HistoricTransient');

	%Create Line Plots of relaxation run.  Create a figure.
	figure

	%Save surface mass balance, by looping through 200 years, or 1000 steps
	surfmb=[]; for i=1:100; surfmb=[surfmb ...
		md.results.TransientSolution(i).SurfaceforcingsMassBalance]; end

	%Plot surface mass balance time series in first subplot
	subplot(3,1,1); plot([0.2:0.2:200],mean(surfmb));

	%Title this plot Mean surface mass balance
	title('Mean Surface mass balance');

	%Save velocity by looping through 1000 steps
	vel=[]; for i=1:100; vel=[vel md.results.TransientSolution(i).Vel]; end

	%Plot velocity time series in second subplot
	subplot(3,1,2); plot([0.2:0.2:200],mean(vel));

	%Title this plot Mean Velocity
	title('Mean Velocity');

	%Save Ice Volume by looping through 1000 steps
	volume=[]; for i=1:100; volume=[volume md.results.TransientSolution(i).IceVolume]; end

	%Plot volume time series in third subplot
	subplot(3,1,3); plot([0.2:0.2:200],volume);

	%Title this plot Mean Velocity and add an x label of years
	title('Ice Volume'); xlabel('years');

end
