function createxml(xmlfilename,md)
%EXTRUDEXML - output an XML file compatible with inishell for automatic gui generation
%
%   The routine creates an XML file that list fields from the underlying classes 
%   in model, and that can be use to render a GUI using the java code inishell
%
%   Usage:
%      createxml(md,xmlfilename)

disp(['creating XML file ' xmlfilename]);

%open file for binary writing
fid=fopen(xmlfilename,'w');
if fid==-1,
	error(['extrudexml error message: could not open ' xmlfilename,' file for ASCII writing']);
end

%Go through all model fields: check that it is a class and call checkconsistency
fields=properties('model');
fprintf(fid, '<inishell_config application="ISSM prototype">\n\n'); % require header for xml file
for i=1:length(fields), 
	field=fields{i};

	%Some properties do not need to XML rendered
	if ismember(field,{'results' 'radaroverlay' 'toolkits' 'private'}),
		continue;
	end

	%Check that current field is an object
	if ~isobject(md.(field))
		error(['field ''' char(field) ''' is not an object']);
	end

	%Create XML file for this subclass
	createxml(md.(field),fid);
end
fprintf(fid, '\n\n</inishell_config>'); % require footer for xml file
%close file
st=fclose(fid);
if st==-1,
	error(['createxml error message: could not close file ' xmlfilename]);
end
