function plot_BC(md,options,width,i,data)

%plot neuman
plot_icefront(md,options,width,i,data)

hold on

[x y z elements is2d isplanet]=processmesh(md,[],options);

%plot dirichlets
dirichleton=getfieldvalue(options,'dirichlet','on');
if strcmpi(dirichleton,'on'),
	h1=plot3(...
		x(find(~isnan(md.stressbalance.spcvx(1:md.mesh.numberofvertices,1)))),...
		y(find(~isnan(md.stressbalance.spcvx(1:md.mesh.numberofvertices,1)))),...
		z(find(~isnan(md.stressbalance.spcvx(1:md.mesh.numberofvertices,1)))),...
		'ro','MarkerSize',14,'MarkerFaceColor','r');
	h2=plot3(...
		x(find(~isnan(md.stressbalance.spcvy(1:md.mesh.numberofvertices,1)))),...
		y(find(~isnan(md.stressbalance.spcvy(1:md.mesh.numberofvertices,1)))),...
		z(find(~isnan(md.stressbalance.spcvy(1:md.mesh.numberofvertices,1)))),...
		'bo','MarkerSize',10,'MarkerFaceColor','b');
	h3=plot3(...
		x(find(~isnan(md.stressbalance.spcvz(1:md.mesh.numberofvertices,1)))),...
		y(find(~isnan(md.stressbalance.spcvz(1:md.mesh.numberofvertices,1)))),...
		z(find(~isnan(md.stressbalance.spcvz(1:md.mesh.numberofvertices,1)))),...
		'yo','MarkerSize',6 ,'MarkerFaceColor','y');
end

%update legend
[legend_h,object_h,plot_h,text_strings]=legend();
legend('off');
if strcmpi(dirichleton,'on'),
	text_strings{end+1}='vx Dirichlet';
	text_strings{end+1}='vy Dirichlet';
	if h3, text_strings{end+1}='vz Dirichlet'; end
	plot_h(end+1)=h1;
	plot_h(end+1)=h2;
	if h3, plot_h(end+1)=h3; end
end
legend(plot_h,text_strings,'location','NorthEast')

hold off

%apply options
options=addfielddefault(options,'title','Boundary conditions');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
