function tips=rifttipsonmesh(md,riftoutline)
%RIFTTIPSONMESH: identify, using a rift outline, the nodes that are tips of 
%                rifts.

%read rifts from outline file
rifts=expread(riftoutline);

tips=[];

for i=1:length(rifts),
	rift=rifts(i);

	x_tip=rift.x(1);
	y_tip=rift.y(1);

	index=find_point(md.mesh.x,md.mesh.y,x_tip,y_tip);
	tips(end+1)=index;

	x_tip=rift.x(end);
	y_tip=rift.y(end);

	index=find_point(md.mesh.x,md.mesh.y,x_tip,y_tip);
	tips(end+1)=index;

end
