%RIFTS class definition
%
%   Usage:
%      rifts=rifts();

classdef rifts
	properties (SetAccess=public) 
		riftstruct     = NaN;
		riftproperties = NaN;
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- rifts -->');
			fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="riftstruct" type="',              class(obj.riftstruct),'" default="',                  obj.riftstruct,'">',              '     <section name="rifts" />','     <help> structure containing all rift information (vertices coordinates, segments, type of melange, ...) </help>','</parameter>');
            fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="riftproperties" type="',            class(obj.riftproperties),'" default="',                obj.riftproperties,'">',   '     <section name="rifts" />','     <help> N/A </help>','</parameter>');
    
        end % }}}
		function obj = rifts(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			if isempty(obj.riftstruct) | isnans(obj.riftstruct),
				numrifts=0;
			else
				numrifts=numel(obj.riftstruct);
			end
			if numrifts,
				if ~(strcmp(domaintype(md.mesh),'2Dhorizontal')),
					md = checkmessage(md,['models with rifts are only supported in 2d for now!']);
				end
				if ~isstruct(obj.riftstruct),
					md = checkmessage(md,['rifts.riftstruct should be a structure!']);
				end
				if ~isempty(find(md.mesh.segmentmarkers>=2)),
					%We have segments with rift markers, but no rift structure!
					md = checkmessage(md,['model should be processed for rifts (run meshprocessrifts)!']);
				end
				for i=1:numrifts,
					md = checkfield(md,'fieldname',sprintf('rifts.riftstruct(%d).fill',i),'values',[WaterEnum() AirEnum() IceEnum() MelangeEnum()]);
				end
			else
				if ~isnans(obj.riftstruct),
					md = checkmessage(md,['riftstruct should be NaN since numrifts is 0!']);
				end
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   rifts parameters:'));

			fielddisplay(obj,'riftstruct','structure containing all rift information (vertices coordinates, segments, type of melange, ...)');
			fielddisplay(obj,'riftproperties','');

		end % }}}
		function marshall(obj,md,fid) % {{{

			%Process rift info
			if isempty(obj.riftstruct) | isnans(obj.riftstruct),
				numrifts=0;
			else
				numrifts=numel(obj.riftstruct);
			end
			numpairs=0;
			for i=1:numrifts,
				numpairs=numpairs+size(obj.riftstruct(i).penaltypairs,1);
			end

			% 2 for nodes + 2 for elements+ 2 for  normals + 1 for length + 1 for fill + 1 for friction + 1 for fraction + 1 for fractionincrement + 1 for state.
			data=zeros(numpairs,12);
			count=1;
			for i=1:numrifts,
				numpairsforthisrift=size(obj.riftstruct(i).penaltypairs,1);
				data(count:count+numpairsforthisrift-1,1:7)=obj.riftstruct(i).penaltypairs;
				data(count:count+numpairsforthisrift-1,8)=obj.riftstruct(i).fill;
				data(count:count+numpairsforthisrift-1,9)=obj.riftstruct(i).friction;
				data(count:count+numpairsforthisrift-1,10)=obj.riftstruct(i).fraction;
				data(count:count+numpairsforthisrift-1,11)=obj.riftstruct(i).fractionincrement;
				data(count:count+numpairsforthisrift-1,12)=obj.riftstruct(i).state;
				count=count+numpairsforthisrift;
			end

			WriteData(fid,'data',numrifts,'enum',RiftsNumriftsEnum(),'format','Integer');
			WriteData(fid,'data',data,'enum',RiftsRiftstructEnum(),'format','DoubleMat','mattype',3);
		end % }}}
	end
end
