%MISCELLANEOUS class definition
%
%   Usage:
%      miscellaneous=miscellaneous();

classdef miscellaneous
	properties (SetAccess=public) 
		notes = '';
		name  = '';
		dummy = struct();
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '<!-- miscellaneous -->\n');            
                    
            % miscellaneous solution parameters
            fprintf(fid,'%s\n%s\n%s\n','<frame key="1" label="miscellaneous parameters">','<section name="miscellaneous" />');                    
                fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','  <parameter key ="notes" type="',class(obj.notes),'" default="',convert2str(obj.notes),'">','     <section name="miscellaneous" />','     <help> notes in a cell of strings </help>','  </parameter>');
                fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','  <parameter key ="name" type="',class(obj.name),'" default="',convert2str(obj.name),'">','     <section name="miscellaneous" />','     <help> model name </help>','  </parameter>');
                fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','  <parameter key ="dummy" type="',class(obj.dummy),'" default="',convert2str(obj.dummy),'">','     <section name="miscellaneous" />','     <help> empty field to store some data </help>','  </parameter>');
            fprintf(fid,'%s\n%s\n','</frame>');    
        
        end % }}}        
		function obj = miscellaneous(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','miscellaneous.name','empty',1);

		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   miscellaneous parameters:'));

			fielddisplay(obj,'notes','notes in a cell of strings');
			fielddisplay(obj,'name','model name');
			fielddisplay(obj,'dummy','empty field to store some data');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','name','format','String');
		end % }}}
	end
end
