#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.2-p3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.2-p3.tar.gz' 'petsc-3.2-p3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.2-p3.tar.gz
mv petsc-3.2-p3/* src/
rm -rf petsc-3.2-p3

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--PETSC_ARCH="$ISSM_ARCH" \
	--with-batch=1 \
	--with-debugging=0 \
	--with-shared-libraries=1 \
	--known-mpi-shared-libraries=1 \
	--with-mpi-dir=/usr/local/intel/mpi/4.0.3.008/lib64/ \
	--with-blas-lapack-dir=/usr/local/intel/Composer/composer_xe_2013.3.163/mkl/ \
	--with-scalapack-lib=/usr/local/intel/Composer/composer_xe_2013.3.163/mkl/lib/intel64/libmkl_scalapack_lp64.a \
	--with-scalapack-include=/usr/local/intel/Composer/composer_xe_2013.3.163/mkl/include/ \
	--with-blacs-lib=/usr/local/intel/Composer/composer_xe_2013.3.163/mkl/lib/intel64/libmkl_blacs_intelmpi_lp64.a \
	--with-blacs-include=/usr/local/intel/Composer/composer_xe_2013.3.163/mkl/include/ \
	--download-mumps=yes \
	--download-scalapack=no \
	--download-blacs=no \
	--download-plapack=no \
	--download-parmetis=yes \
	--with-pic=1

echo "== Follow PETSc's instructions"
