/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import gui_elements.TextfieldPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class PathPanel
extends TextfieldPanel
implements ActionListener {
    private static final long serialVersionUID = 1486664773406118295L;
    JButton select_button;

    public PathPanel(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        super(element, controlledPanel);
        if (element.getAttribute("type").equals("path")) {
            this.select_button = new JButton("Select Path");
        } else if (element.getAttribute("type").equals("file")) {
            this.select_button = new JButton("Select File");
        } else {
            throw new GUIBuildException("PathPanel is not applicable for parameter types other than 'file' and 'path'.");
        }
        this.remove(this.textfield);
        this.add((Component)this.textfield, "cell 1 0, growx, span2");
        this.select_button.addActionListener(this);
        this.select_button.setActionCommand("open chooser");
        this.select_button.setVisible(true);
        this.add((Component)this.select_button, "cell 3 0, growx, wrap");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("open chooser") && actionEvent.getSource() == this.select_button) {
            try {
                this.chooseFile();
            }
            catch (GUIBuildException gUIBuildException) {
                gUIBuildException.printStackTrace();
            }
        }
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
        String string3 = (String)hashMap.get(this.hashKey);
        if (string3 != null) {
            this.textfield.setText(string3);
        }
        this.checkBgColor();
    }

    public void chooseFile() throws GUIBuildException {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        if (this.element.getAttribute("type").equals("path")) {
            jFileChooser.setFileSelectionMode(1);
        } else if (this.element.getAttribute("type").equals("file")) {
            jFileChooser.setFileSelectionMode(0);
        } else {
            throw new GUIBuildException("PathPanel is not applicable for parameter types other than 'file' and 'path'.");
        }
        int n = jFileChooser.showOpenDialog(new JPanel());
        if (n == 0) {
            if (this.element.getAttribute("type").equals("path")) {
                this.textfield.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            } else {
                this.textfield.setText(jFileChooser.getSelectedFile().getName());
            }
            this.checkBgColor();
        }
    }
}

