/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import main.GUIBuilder;
import main.XMLHelper;
import org.w3c.dom.Element;

public abstract class OptionPanel
extends ControlledPanel
implements ItemListener {
    private static final long serialVersionUID = 88L;
    protected LinkedList<String> defaultTrues;
    protected EventListenerList listenerList;
    protected String[] values;
    protected String[] labels;
    protected String[] helptexts;

    public OptionPanel(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        this(element, controlledPanel, true);
    }

    public OptionPanel(Element element, ControlledPanel controlledPanel, boolean bl) throws GUIBuildException {
        super(element, controlledPanel, bl);
        String string = "";
        if (element.hasAttribute("default")) {
            string = element.getAttribute("default");
        }
        this.listenerList = new EventListenerList();
        Element[] elementArray = XMLHelper.getElementArray(element, "option");
        this.defaultTrues = new LinkedList();
        this.values = new String[elementArray.length];
        this.labels = new String[elementArray.length];
        this.helptexts = new String[elementArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            this.values[i] = elementArray[i].getAttribute("value");
            this.labels[i] = elementArray[i].getAttribute("label");
            if (this.labels[i] == "") {
                this.labels[i] = this.values[i];
            }
            if (string.equals(this.values[i])) {
                this.defaultTrues.add(this.values[i]);
            }
            if (elementArray[i].hasAttribute("default") && elementArray[i].getAttribute("default").equals("true")) {
                this.defaultTrues.add(this.values[i]);
            }
            this.helptexts[i] = XMLHelper.getChildElementContent(elementArray[i], "help");
        }
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
    }

    public void handleItemEvent(ItemEvent itemEvent, String string) {
        this.handleItemEvent(itemEvent, string, false, null, null, null);
    }

    public void handleItemEvent(ItemEvent itemEvent, String string, boolean bl, HashMap hashMap, String string2, String string3) {
        Element element = XMLHelper.getCertainChildElement(this.element, "option", "label", string);
        if (element == null) {
            element = XMLHelper.getCertainChildElement(this.element, "option", "value", string);
        }
        if (itemEvent.getStateChange() == 1) {
            try {
                GUIBuilder.recursiveBuild(element, this, bl, hashMap, string2, string3);
            }
            catch (GUIBuildException gUIBuildException) {
                gUIBuildException.printStackTrace();
            }
        } else {
            try {
                GUIBuilder.recursiveDestruct(element, this);
            }
            catch (GUIBuildException gUIBuildException) {
                gUIBuildException.printStackTrace();
            }
        }
    }
}

