#!/bin/bash
set -eu

#Some cleanup
rm -rf install src

git clone -b ampi git://git.mcs.anl.gov/adol-c.git src
#git reset --hard b254b2a001a1b7a024a9184cd087ae06eb975cad

#Compile ADOL-C
cd src
autoreconf -f -i 

./configure --prefix=$ISSM_DIR/externalpackages/adolc/install  \
	--libdir=$ISSM_DIR/externalpackages/adolc/install/lib \
	--with-mpi-root="/nasa/sgi/mpt/2.06rp16/" \
	--enable-ampi \
	--with-ampi=$ISSM_DIR/externalpackages/adjoinablempi/install \
        --with-soname=adolc \
	--disable-tapedoc-values

make clean
if [ $# -eq 0 ]; then
	make V=1
else
	make -j $1 V=1
fi
make V=1 install
