#!/bin/sh

#petsc 3.4
#mpich 3.0.4

./configure \
	--prefix=$ISSM_DIR \
	--with-matlab-dir="$ISSM_DIR/externalpackages/matlab/install" \
	--with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
	--with-metis-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install  \
	--with-mpi-include=$ISSM_DIR/externalpackages/mpich/install/include  \
	--with-mpi-libflags=" $ISSM_DIR/externalpackages/mpich/install/lib/libpmpich.a $ISSM_DIR/externalpackages/mpich/install/lib/libmpich.a $ISSM_DIR/externalpackages/mpich/install/lib/libmpl.a " \
	--with-petsc-arch=$ISSM_ARCH \
	--with-dakota-dir=$ISSM_DIR/externalpackages/dakota/install \
	--with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-scalapack-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-chaco-dir="$ISSM_DIR/externalpackages/chaco/install" \
	--with-fortran-lib="/usr/lib/gcc/i686-apple-darwin10/4.2.1/x86_64/libgfortran.a" \
	--with-math-lib="/usr/lib/libm.dylib" \
	--with-graphics-lib="/usr/X11/lib/libX11.dylib" \
	--with-cxxoptflags=" -fno-common -no-cpp-precomp -fexceptions -arch x86_64 -mmacosx-version-min=10.5  -O3 -DNDEBUG -w "\
	--with-numthreads=8
