/*!\file Xy2ll.h
 * \brief: prototype for x/y to lat/long coordinate mex module.
 */

#ifndef _XY2LL_H
#define _XY2LL_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

#include "../bindings.h"
#include "../../c/main/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__  "Xy2ll"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define X_IN   prhs[0]
#define Y_IN   prhs[1]
#define SGN_IN prhs[2]
/* serial output macros: */
#define LAT_OUT (mxArray**)&plhs[0]
#define LON_OUT (mxArray**)&plhs[1]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define X_IN   PyTuple_GetItem(args,0)
#define Y_IN   PyTuple_GetItem(args,1)
#define SGN_IN PyTuple_GetItem(args,2)
/* serial output macros: */
#define LAT_OUT output,0
#define LON_OUT output,1
#endif

/* serial arg counts: */
#undef NRHS
#define NRHS  3
#undef NLHS
#define NLHS  2

#endif
