#ifndef _FORTRAN_MAPPING_H_
#define _FORTRAN_MAPPING_H_
/*
 * Fortran_Mapping.h
 *     Description:  Fortran to C define to use Scalapack in a C program
 */

/*We transform every call to Fortran functions into their real symbolic name in the Scalapack, Blacs, Lapack and Blas libraries. 
 * We had to look for these exact symbols in these libraries using nm | grep FORTRAN_NAME. In fact, the symbol naming is not well defined: see for example 
 * numroc_ and blacs_gridinit__ (one underscore, then two). */

#define BLACS_GRIDINFO(...) blacs_gridinfo__(__VA_ARGS__)
#define SL_INIT(...) sl_init__(__VA_ARGS__)
#define BLACS_GRIDEXIT(...) blacs_gridexit__(__VA_ARGS__)
#define BLACS_EXIT(...) blacs_exit__(__VA_ARGS__) 
#define DESCINIT(...) descinit_(__VA_ARGS__)
#define NUMROC(...) numroc_(__VA_ARGS__)
#define BLACS_GET(...) blacs_get__(__VA_ARGS__) 
#define BLACS_GRIDINIT(...) blacs_gridinit__(__VA_ARGS__)
#define BLACS_GRIDMAP(...) blacs_gridmap__(__VA_ARGS__)
#define PDGETRF(...) pdgetrf_(__VA_ARGS__)
#define PDGETRI(...) pdgetri_(__VA_ARGS__)

/*Here, we clobber the fortran definition of these routines. Remember, every variable in fortran is passed by a pointer, and the 
 * ordering of matrices is column oriented*/

void sl_init__(int*,int*,int*); 
void blacs_exit__(int*);
void blacs_gridinfo__(int*,int*,int*,int*,int*);
void descinit_(int[9],int*,int*,int*,int*,int*,int*,int*,int*,int*);
void blacs_gridexit__(int*);
int numroc_(int*,int*,int*,int*,int*);
void blacs_get__(int*,int*,int*);
void blacs_gridinit__(int*,char*,int*,int*);
void blacs_gridmap__(int*,int *,int*,int*,int*);

/*LU factorization*/
void pdgetrf_(int* M,int* N,double* A,int* IA,int* JA,int* DESCA,int* IPIV,int* INFOVAR);  
void pdgetri_(int* N,double* A,int* IA,int* JA,int* DESCA,int* IPIV,double* WORK,int* LWORK,int* IWORK,int* LIWORK,int*	INFOVAR);

#endif
