/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui_elements.GUIBuildException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLHelper {
    public static String[] findApplicableValues(Element element, String string, String string2, String string3) {
        String[] stringArray = XMLHelper.getAttributesFromChildren(element, string, string2);
        if (stringArray.length == 0 && string3 != null) {
            return new String[]{string3};
        }
        if (stringArray.length > 0 && string3 != null) {
            if (XMLHelper.getCertainChildElement(element, string, string2, string3) != null) {
                return new String[]{string3};
            }
            return new String[0];
        }
        if (stringArray.length > 0 && string3 == null) {
            return stringArray;
        }
        if (stringArray.length == 0 && string3 == null) {
            return null;
        }
        return null;
    }

    public static String[] getAttributesFromChildren(Element element, String string, String string2) {
        Element[] elementArray = XMLHelper.getElementArray(element, string);
        String[] stringArray = new String[elementArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            stringArray[i] = elementArray[i].getAttribute(string2);
        }
        return stringArray;
    }

    public static Element getCertainChildElement(Element element, String string, String string2, String string3) {
        Element[] elementArray;
        for (Element element2 : elementArray = XMLHelper.getElementArray(element, string)) {
            if (!element2.hasAttribute(string2) || !element2.getAttribute(string2).equals(string3)) continue;
            return element2;
        }
        return null;
    }

    public static String getChildElementContent(Element element, String string) {
        Element[] elementArray = XMLHelper.getElementArray(element, string);
        if (elementArray.length == 0) {
            return null;
        }
        return elementArray[0].getTextContent();
    }

    public static Element[] getElementArray(Element element, String string) {
        if (!element.hasChildNodes()) {
            return new Element[0];
        }
        NodeList nodeList = element.getChildNodes();
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(string)) continue;
            linkedList.add((Element)node);
        }
        Element[] elementArray = new Element[linkedList.size()];
        return linkedList.toArray(elementArray);
    }

    public static Element[] getElementArray(Element element, String[] stringArray) {
        if (!element.hasChildNodes()) {
            return new Element[0];
        }
        NodeList nodeList = element.getChildNodes();
        LinkedList<Element> linkedList = new LinkedList<Element>();
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!((Element)node).getTagName().equals(stringArray[j])) continue;
                linkedList.add((Element)node);
                continue block0;
            }
        }
        Element[] elementArray = new Element[linkedList.size()];
        return linkedList.toArray(elementArray);
    }

    public static String printToScreen(Document document) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return null;
    }

    public static Document readXML(String string, String string2) throws GUIBuildException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", string2);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new GUIBuildException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new GUIBuildException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new GUIBuildException(iOException.getMessage());
        }
        document.normalize();
        document.normalizeDocument();
        XMLHelper.resolveIncludes(document, string2);
        XMLHelper.resolveReferences(document);
        XMLHelper.recursivelyResolveSections(document.getDocumentElement(), null);
        XMLHelper.recursivelyResolveReplaces(document.getDocumentElement(), null);
        return document;
    }

    public static void recursivelyResolveReplaces(Element element, String string) {
        String[] stringArray = XMLHelper.findApplicableValues(element, "replace", "name", string);
        Element[] elementArray = XMLHelper.getElementArray(element, "replace");
        for (Element object : elementArray) {
            element.removeChild(object);
        }
        if (stringArray == null) {
            NodeList nodeList = element.getChildNodes();
            Node[] nodeArray = new Node[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeArray[i] = nodeList.item(i);
            }
            for (Node node : nodeArray) {
                if (node.getNodeType() != 1) continue;
                XMLHelper.recursivelyResolveReplaces((Element)node, string);
            }
        } else if (stringArray.length == 0) {
            element.getParentNode().removeChild(element);
        } else if (stringArray != null) {
            for (String string2 : stringArray) {
                Element element2 = (Element)element.cloneNode(true);
                element2.setAttribute("key", element2.getAttribute("key").replaceAll("%", string2));
                element2.setAttribute("replaced", string2);
                element.getParentNode().appendChild(element2);
                NodeList nodeList = element2.getChildNodes();
                Node[] nodeArray = new Node[nodeList.getLength()];
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    nodeArray[i] = nodeList.item(i);
                }
                for (Node node : nodeArray) {
                    if (node.getNodeType() != 1) continue;
                    XMLHelper.recursivelyResolveReplaces((Element)node, string2);
                }
            }
            element.getParentNode().removeChild(element);
        }
    }

    public static void recursivelyResolveSections(Element element, String string) {
        String[] stringArray = XMLHelper.findApplicableValues(element, "section", "name", string);
        Element[] elementArray = XMLHelper.getElementArray(element, "section");
        for (Element object : elementArray) {
            element.removeChild(object);
        }
        if (stringArray == null) {
            NodeList nodeList = element.getChildNodes();
            Node[] nodeArray = new Node[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeArray[i] = nodeList.item(i);
            }
            for (Node node : nodeArray) {
                if (node.getNodeType() != 1) continue;
                XMLHelper.recursivelyResolveSections((Element)node, string);
            }
        } else if (stringArray != null) {
            for (String string2 : stringArray) {
                Element element2 = (Element)element.cloneNode(true);
                element2.setAttribute("section", string2);
                element.getParentNode().appendChild(element2);
                NodeList nodeList = element2.getChildNodes();
                Node[] nodeArray = new Node[nodeList.getLength()];
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    nodeArray[i] = nodeList.item(i);
                }
                for (Node node : nodeArray) {
                    if (node.getNodeType() != 1) continue;
                    XMLHelper.recursivelyResolveSections((Element)node, string2);
                }
            }
            element.getParentNode().removeChild(element);
        }
    }

    public static Document resolveIncludes(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName("include");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = ((Element)nodeList.item(i)).getAttribute("path");
            try {
                Document document2 = XMLHelper.readXML(string2, string);
                NodeList nodeList2 = document2.getChildNodes().item(0).getChildNodes();
                Node node = nodeList.item(i).getParentNode();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = document.importNode(nodeList2.item(j), true);
                    node.appendChild(node2);
                }
                continue;
            }
            catch (GUIBuildException gUIBuildException) {
                gUIBuildException.printStackTrace();
            }
        }
        return document;
    }

    public static Document resolveReferences(Document document) {
        NodeList nodeList = document.getElementsByTagName("reference");
        NodeList nodeList2 = document.getElementsByTagName("parametergroup");
        while (nodeList.getLength() != 0) {
            Element element = (Element)nodeList.item(0);
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!((Element)node).getAttribute("name").equals(element.getAttribute("name"))) continue;
                NodeList nodeList3 = node.getChildNodes();
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Node node2 = nodeList3.item(j).cloneNode(true);
                    element2.appendChild(node2);
                }
            }
        }
        while (nodeList2.getLength() != 0) {
            nodeList2.item(0).getParentNode().removeChild(nodeList2.item(0));
        }
        return document;
    }

    public static String getString(Node node) {
        String string = "";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error converting to String", exception);
        }
        return string;
    }
}

