/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import gui_elements.TextfieldPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;

public class IntegerPanel
extends TextfieldPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = -8959578535487185306L;
    private int defaultvalue;
    private int maximumvalue;
    private int minimumvalue;
    private boolean printPlus;
    private final JButton down;
    private final JButton up;

    public IntegerPanel(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        super(element, controlledPanel);
        this.setDefaultvalue(0);
        this.minimumvalue = Integer.MIN_VALUE;
        this.maximumvalue = Integer.MAX_VALUE;
        this.printPlus = false;
        if (element.getAttribute("type").equals("integer+")) {
            this.setPrintplus(true);
        } else {
            this.setPrintplus(false);
        }
        if (element.hasAttribute("default")) {
            this.setDefaultvalue(element.getAttribute("default"));
        }
        if (element.hasAttribute("maximum")) {
            this.setMaximumvalue(element.getAttribute("maximum"));
        }
        if (element.hasAttribute("minimum")) {
            this.setMinimumvalue(element.getAttribute("minimum"));
        }
        this.textfield.setColumns(4);
        this.textfield.invalidate();
        this.textfield.setHorizontalAlignment(4);
        this.up = new JButton("+");
        this.up.addActionListener(this);
        this.down = new JButton("-");
        this.down.addActionListener(this);
        this.add((Component)this.up, "split 2, growx, ay top");
        this.add((Component)this.down, "growx, ay top");
        this.textfield.addActionListener(this);
        this.textfield.addFocusListener(this);
    }

    private static int parse(String string) throws NumberFormatException {
        char c = string.charAt(0);
        if (c == '+') {
            return Integer.parseInt(string.substring(1));
        }
        if (c == '-') {
            return Integer.parseInt(string);
        }
        return Integer.parseInt(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.up) {
            this.manipulateNumber(1);
        } else if (actionEvent.getSource() == this.down) {
            this.manipulateNumber(-1);
        } else if (actionEvent.getSource() == this.textfield) {
            this.parseTextfield();
        }
    }

    @Override
    public void set(HashMap hashMap, String string, String string2) {
        String string3 = (String)hashMap.get(this.hashKey);
        if (string3 != null) {
            try {
                Integer.parseInt(string3);
                this.textfield.setText(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.parseTextfield();
    }

    public void manipulateNumber(int n) {
        int n2;
        try {
            n2 = this.parseTextfield();
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n2 + n <= this.maximumvalue && n2 + n >= this.minimumvalue) {
            n2 += n;
        } else if (n2 + n < this.minimumvalue) {
            n2 = this.minimumvalue;
        } else if (n2 + n > this.maximumvalue) {
            n2 = this.maximumvalue;
        }
        this.printToTextfield(n2);
    }

    public int parseTextfield() throws NumberFormatException {
        try {
            return IntegerPanel.parse(this.textfield.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "The textfield " + this.getKey() + " does not contain a number.");
            throw numberFormatException;
        }
    }

    public void printToTextfield(int n) {
        if (this.printPlus && n > 0) {
            this.textfield.setText("+" + n);
        } else {
            this.textfield.setText("" + n);
        }
        this.checkBgColor();
    }

    public void setDefaultvalue(int n) {
        this.defaultvalue = n;
        this.printToTextfield(n);
    }

    public void setDefaultvalue(String string) {
        this.defaultvalue = IntegerPanel.parse(string);
        this.printToTextfield(this.defaultvalue);
    }

    public void setMaximumvalue(int n) {
        this.maximumvalue = n;
    }

    public void setMaximumvalue(String string) {
        this.maximumvalue = IntegerPanel.parse(string);
    }

    public void setMinimumvalue(int n) {
        this.minimumvalue = n;
    }

    public void setMinimumvalue(String string) {
        this.minimumvalue = IntegerPanel.parse(string);
    }

    public void setPrintplus(boolean bl) {
        this.printPlus = bl;
        this.printToTextfield(IntegerPanel.parse(this.textfield.getText()));
    }
}

