/*
 * Decompiled with CFR 0.152.
 */
package gui_elements;

import gui_elements.ControlledPanel;
import gui_elements.GUIBuildException;
import gui_elements.OptionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;

public class CheckBoxPanel
extends OptionPanel {
    private static final long serialVersionUID = 552186457208697362L;
    private final JCheckBox[] boxes = new JCheckBox[this.values.length];
    String concat = "";
    private String setKey = null;
    private String setValue = null;
    private boolean doSet = false;
    private HashMap setMap;

    public CheckBoxPanel(Element element, ControlledPanel controlledPanel) throws GUIBuildException {
        super(element, controlledPanel);
        for (int i = 0; i < this.values.length; ++i) {
            this.boxes[i] = new JCheckBox(this.values[i]);
            this.add((Component)this.boxes[i], "cell 1 " + i + ", wrap, ay top");
            String string = "";
            if (i > 0) {
                string = ", gapleft 12";
            }
            this.add((Component)ControlledPanel.createHelpPane(this.helptexts[i]), "cell 6 " + i + ", width 200:400:400, wrap" + string);
            this.boxes[i].setBackground(Color.white);
            this.boxes[i].setVisible(true);
            this.boxes[i].addItemListener(this);
            if (!this.defaultTrues.contains(this.values[i])) continue;
            this.boxes[i].setSelected(true);
            this.concat = this.concat + this.values[i] + " ";
        }
    }

    @Override
    public void close() {
        for (JCheckBox jCheckBox : this.boxes) {
            jCheckBox.setSelected(false);
        }
    }

    @Override
    public String getValue() {
        if (!this.isOptional() && this.concat.equals("")) {
            JOptionPane.showMessageDialog(null, "No option was selected for " + this.getKey() + " (section '" + this.getSection().toUpperCase() + "')" + ".\nA value is required. Your .ini-file is probably incorrect.", "Problem when building .ini file", 2);
        }
        if (this.concat.equals("")) {
            return null;
        }
        return this.concat.trim();
    }

    @Override
    public synchronized void set(HashMap hashMap, String string, String string2) {
        String string3 = ((String)hashMap.get(this.hashKey)).toUpperCase();
        String[] stringArray = string3.split("\\s+");
        for (JCheckBox jCheckBox : this.boxes) {
            jCheckBox.setSelected(false);
            for (String string4 : stringArray) {
                if (!string4.equals(jCheckBox.getText())) continue;
                this.doSet = true;
                this.setKey = string;
                this.setValue = string2;
                this.setMap = hashMap;
                jCheckBox.setSelected(true);
            }
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        String string = ((JCheckBox)itemEvent.getItemSelectable()).getText();
        if (itemEvent.getStateChange() == 1) {
            this.concat = this.concat + string + " ";
        } else {
            this.concat = this.concat.replaceAll(new String(" " + string + " "), " ");
            this.concat = this.concat.replaceFirst(new String("^" + string + " "), "");
        }
        super.handleItemEvent(itemEvent, string, this.doSet, this.setMap, this.setKey, this.setValue);
        this.doSet = false;
        this.setKey = null;
        this.setMap = null;
        this.setValue = null;
    }
}

