function exp2shp(shapefilename,expfilename)
%SHPWRITE - write a shape file from a contour structure
%
%   Usage:
%      exp2shp(shapefilename,expfilename)
%
%   Example:
%      exp2shp('domainoutline.shp','domainoutline.exp')
%
%   See also SHPREAD, SHPWRITE, SHP2EXP

shp=expread(expfilename);

%initialize number of profile
count=0;

contours=struct([]);
for i=1:length(shp),
	contours(i).Geometry='Polygon';
	contours(i).id=i;
	contours(i).X=shp(i).x;
	contours(i).Y=shp(i).y;
end
	
shapewrite(contours,shapefilename);
end
