if perform(org,'ModelHO')
  % Load Model
  md = loadmodel(org,'Control_drag');
  md.inversion.iscontrol=0;

  disp('   Extruding mesh')
  number_of_layers=3;
  md=extrude(md,number_of_layers,0.9);

  disp('   Using HO Ice Flow Model')
  md=setflowequation(md, 'HO', 'all');

  % Solve
  md=solve(md,StressbalanceSolutionEnum);

  % Save Model
  savemodel(org,md);
end
