from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md.extrude(3,1.)
md=setflowequation(md,'SSA','all')
md.timestepping.time_step=0
md.cluster=generic('name',oshostname(),'np',1)
md.toolkits.DefaultAnalysis=issmgslsolver()
md.autodiff.isautodiff=True
md=solve(md,ThermalSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Temperature','BasalforcingsMeltingRate']
field_tolerances=[1e-13,1e-13]
field_values=[\
	md.results.ThermalSolution.Temperature,\
	md.results.ThermalSolution.BasalforcingsMeltingRate,\
	]
