import numpy

def expwrite(contours,filename):
	"""
	EXPWRITE - write an Argus file from a structure given in input

	   This routine write an Argus file form a structure containing the fields:
	   x and y of the coordinates of the points.
	   The first argument is the structure containing the points coordinates 
	   and the second one the file to be write.

	   Usage:
	      expwrite(contours,filename)

	   Example:
	      expwrite(coordstruct,'domainoutline.exp')

	   See also EXPDOC, EXPREAD, EXPWRITEASVERTICES
	"""

	fid=open(filename,'w')
	for contour in contours:
		if numpy.size(contour['x'])!=numpy.size(contour['y']):
			raise RuntimeError("contours x and y coordinates must be of identical size")
   
		if 'name' in contour:
			fid.write("%s%s\n" % ('## Name:',contour['name']))
		else:
			fid.write("%s%s\n" % ('## Name:',filename))
   
		#Add density if it's not there
		if 'density' not in contour:
			contour['density']=1

		fid.write("%s\n" % '## Icon:0')
		fid.write("%s\n" % '# Points Count Value')
		fid.write("%i %f\n" % (numpy.size(contour['x']),contour['density']))
		fid.write("%s\n" % '# X pos Y pos')
		for x,y in zip(contour['x'],contour['y']):
			fid.write("%10.10f %10.10f\n" % (x,y))
		fid.write("\n")

	fid.close()

