function comparemodels(md1,md2);

	%loop over model fields
	model_fields=fields(md1);
	for i=1:length(model_fields),
		field1=md1.(model_fields{i});
		field2=md2.(model_fields{i});
		if isobject(field1), %recursive call
			object_fields=fields(md1.(model_fields{i}));
			for j=1:length(object_fields),
				field1=md1.(model_fields{i}).(object_fields{j});
				field2=md2.(model_fields{i}).(object_fields{j});
				compare([model_fields{i} '.' object_fields{j}],field1,field2);
			end
		else
			compare(model_fields{i},field1,field2);
		end
	end

end

function compare(fieldname,field1,field2),
	if any(size(field1)~=size(field2)),
		disp([fieldname ' do not have the same size']);
	elseif isnumeric(field1),
		if numel(field1)==1 & isnan(field1) & isnan(field2),
			%Do not do anything
		elseif any(field1~=field2),
			disp([fieldname ' differs']);
		end
	end

end
