# ISSM Options {{{
option(DAKOTA "DAKOTA" OFF)
option(PETSC "PETSC" OFF)
option(MUMPS "MUMPS" OFF)
#option(GSL "GSL" OFF)
option(TRANSIENT "TRANSIENT" ON)
option(STEADYSTATE "STEADYSTATE" ON)
option(PROGNOSTIC "PROGNOSTIC" ON)
option(THERMAL "THERMAL" ON)
option(GIA "GIA" OFF)
option(CONTROL "CONTROL" ON)
option(HYDROLOGY "HYDROLOGY" ON)
option(DIAGNOSTIC "DIAGNOSTIC" ON)
option(BALANCED "BALANCED" ON)
option(SLOPE "SLOPE" ON)
option(GROUNDINGLINE "GROUNDINGLINE" ON)
option(RIFTS "RIFTS" ON)
option(ANDROID "ANDROID" OFF)
option(THREED "THREED" ON)
option(MPI "MPI" OFF)
option(METIS "METIS" OFF)
option(KRIGING "KRIGING" OFF)
# }}}

if(NOT GSL_DIR)
    message(FATAL_ERROR "Non GSL build not supported")
else(NOT GSL_DIR)
    find_path(GSL lib ${GSL_DIR})

    if(GSL)
        message("Found GSL: ${GSL_DIR}")
        set(GSL_INC_DIR ${GSL_DIR}/include)
        set(GSL_LIB_DIR ${GSL_DIR}/lib)
    else(GSL)
        message(FATAL_ERROR "GSL installation directory not found!")
    endif(GSL)
endif(NOT GSL_DIR)
