#!/bin/bash

#Some cleanup
rm -rf install petsc-3.4.3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.4.3.tar.gz' 'petsc-3.4.3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.4.3.tar.gz
mv petsc-3.4.3/* src/
rm -rf petsc-3.4.3

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_ARCH="$ISSM_ARCH" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-batch=1  \
 --with-debugging=0 \
 --with-shared-libraries=1 \
 --known-mpi-shared-libraries=1 \
 --with-mpi=1 \
 --with-mpi-lib="/nasa/mvapich2/1.6.sles11/gcc/lib/libmpich.a"\
 --with-mpi-include="/nasa/mvapich2/1.6.sles11/gcc/include" \
 --download-f-blas-lapack=yes \
 --download-scalapack=yes \
 --download-blacs=yes \
 --download-mumps=yes \
 --download-metis=yes \
 --download-parmetis=yes \
 --download-trilinos=yes \
 --download-euclid=yes \
 --download-hypre=yes \
 --COPTFLAGS="-lmpich" \
 --FOPTFLAGS="-lmpich" \
 --CXXOPTFLAGS="-lmpich"

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l select=1:ncpus=1:model=wes 
#PBS -l walltime=200 
#PBS -W group_list=s1010
#PBS -m e 

. /usr/share/modules/init/bash 
module load mpi-mvapich2/1.6/gcc
module load gcc/4.7.0

export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-linux-gnu-ia64-intel.py
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub -q devel script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
