#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.1-p7 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.1-p7.tar.gz' 'petsc-3.1-p7.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.1-p7.tar.gz
mv petsc-3.1-p7/* src/
rm -rf petsc-3.1-p7

#configure
cd src
./config/configure.py  \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --PETSC_ARCH=macosx-gnu \
 --with-mpi-dir=$ISSM_DIR/externalpackages/mpich/install \
 --with-debugging=0 \
 --with-shared=0 \
 --download-mumps=yes \
 --download-scalapack=yes \
 --download-blacs=yes \
 --download-blas=yes \
 --download-f-blas-lapack=yes \
 --download-plapack=yes \
 --FFLAGS="-I$ISSM_DIR/externalpackages/mpich/install/include -arch i386" \
 --COPTFLAGS="-march=opteron -O2 -arch i386" \
 --FOPTFLAGS="-march=opteron -O2 -arch i386" \
 --CXXOPTFLAGS="-march=opteron -O2 -arch i386" \
 --download-parmetis=yes

#Compile petsc and install it
make
make install
