#!/bin/bash
set -eu

#Some cleanup
rm -rf install
rm -rf modules-3.2.10
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/modules-3.2.10.tar.gz' 'modules-3.2.10.tar.gz'

#Untar 
tar -zxvf  modules-3.2.10.tar.gz

#Move modules into src directory

#Configure modules
cd modules-3.2.10
sudo ./configure \
	--prefix=/usr/local/modules \
	--with-tcl-lib=$ISSM_DIR/externalpackages/tcl/install/Library/Frameworks/Tcl.framework/Versions/8.5\
	--with-tcl-inc=$ISSM_DIR/externalpackages/tcl/install/Library/Frameworks/Tcl.framework/Versions/8.5/Headers\
	--with-tcl-ver=8.5 \
	--with-tclx-lib=$ISSM_DIR/externalpackages/tclx/install/lib/tclx8.4\
    --with-tclx-inc=$ISSM_DIR/externalpackages/tclx/install/include\
	--with-tclx-ver=8.4 \
	--with-version-path=/usr/local/modules/versions \
	--with-skel-path=/usr/local/modules/etc/skel \
	--with-etc-path=/usr/local/modules/etc \
	--with-module-path=/usr/local/modules/files \
	--disable-dependency-tracking

#Compile and install modules
if [ $# -eq 0 ]; then
	sudo make
else
	sudo make -j $1
fi
sudo make install
