md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');

% Use of ispdd and isdelta18o methods
md.surfaceforcings = SMBpdd();
md.surfaceforcings.isdelta18o=1;

% Add temperature, precipitation and delta18o needed to measure the surface mass balance
% creating delta18o
load '../Data/delta18o.data'
md.surfaceforcings.delta18o=delta18o;
% creating delta18oSurface
md.surfaceforcings.delta18o_surface(1,1:(length(delta18o))) = 0;
md.surfaceforcings.delta18o_surface(2,:) = delta18o(2,:);

% creating Present day and lgm temperatures
% Same temperature over the all region:
tmonth(1:12)=238.15+20.;
for imonth=0:11
    md.surfaceforcings.temperatures_presentday(1:md.mesh.numberofvertices,imonth+1)=tmonth(imonth+1);
    md.surfaceforcings.temperatures_lgm(1:md.mesh.numberofvertices,imonth+1)=tmonth(imonth+1)-20.;
    % Time for the last line:
    md.surfaceforcings.temperatures_presentday(md.mesh.numberofvertices+1,imonth+1)=((imonth+1)/12);
    md.surfaceforcings.temperatures_lgm(md.mesh.numberofvertices+1,imonth+1)=((imonth+1)/12);
end

% creating initialization and spc temperatures initialization and spc
md.thermal.spctemperature=mean(md.surfaceforcings.temperatures_lgm(1:md.mesh.numberofvertices,1:12),2); %-10*ones(md.mesh.numberofvertices,1);
md.thermal.spctemperature=repmat(md.thermal.spctemperature,1,md.timestepping.final_time/md.timestepping.time_step);
itemp=0:md.timestepping.time_step:md.timestepping.final_time-md.timestepping.time_step;
md.thermal.spctemperature(md.mesh.numberofvertices+1,:)=itemp;

md.initialization.temperature=md.surfaceforcings.temperatures_lgm(1:md.mesh.numberofvertices,1); %*ones(md.mesh.numberofvertices,1);

% creating precipitation
for imonth=0:11
    md.surfaceforcings.precipitations_presentday(1:md.mesh.numberofvertices,imonth+1)=-0.4*10^(-6)*md.mesh.y+0.5;
    md.surfaceforcings.precipitations_presentday(md.mesh.numberofvertices+1,imonth+1)=((imonth+1)/12);
end

% time steps and resolution
md.timestepping.time_step=20;
md.timestepping.final_time=60;

% 
md.transient.requested_outputs={'default','SurfaceforcingsMonthlytemperatures'};
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).SurfaceforcingsMonthlytemperatures),...
	(md.results.TransientSolution(1).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).SurfaceforcingsMonthlytemperatures),...
	(md.results.TransientSolution(2).SurfaceforcingsMassBalance),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Pressure),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).SurfaceforcingsMonthlytemperatures),...
	(md.results.TransientSolution(3).SurfaceforcingsMassBalance),...
	};
