/*!\file EdgeDetection.c
 * \brief: edge detection for a boolean image
*/

#include "./EdgeDetection.h"

void EdgeDetectionUsage(void){/*{{{*/
	_printf0_("EDGEDETECTION usage- detect edges of a boolean image\n");
	_printf0_("\n");
	_printf0_("   Usage:\n");
	_printf0_("      contours=EdgeDetection(image);\n");
	_printf0_("\n");
	_printf0_("      image: boolean matrix\n");
	_printf0_("\n");
	_printf0_("   Example:\n");
	_printf0_("      load('velocities.mat');\n");
	_printf0_("      md.inversion.vx_obs=EdgeDetection(x_n,y_m,vx,md.mesh.x,md.mesh.y,0);\n");
	_printf0_("\n");
}/*}}}*/
WRAPPER(EdgeDetection){

	/*input: */
	bool *image = NULL;
	int   M,N;

	/* output: */
	Contours* contours=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&EdgeDetectionUsage);

	/*Input datasets: */
	FetchData(&image,&M,&N,IMAGE);

	/*Initialize output: */
	contours=new Contours();

	/* Run core computations: */
	EdgeDetectionx(contours,image,M,N);

	/*Write data: */
	WriteData(CONTOURS,contours);

	/*Clean up*/
	xDelete<bool>(image);
	delete contours;

	/*end module: */
	MODULEEND();
}
