function expremovestraightsegments(newfilename,filename,cutoff)
%EXPREMOVESTRAIGHTSEGMENTS:  remove straight segments connecting contours.
%
% Usage: expremovestraightsegments('argus.exp',100); 
%
%

a=expread(filename,1);
newcontours=a(1);

for i=1:length(a),
	contour=a(i);

	s=sqrt(contour.x.^2+contour.y.^2);
	d=diff(s);

	pos=find(abs(d)>cutoff);
	pos=[0;pos;length(contour.x)];

	for j=1:length(pos)-1,

		newcontour=contour;
		newcontour.x=contour.x(pos(j)+1:pos(j+1));
		newcontour.y=contour.y(pos(j)+1:pos(j+1));
		newcontour.nods=length(newcontour.x);
		newcontours(end+1)=newcontour;
	end
end
newcontours=newcontours(2:end);

expwrite(newcontours,newfilename);
