%FLAIM class definition
%
%   Usage:
%      flaim=flaim();

classdef flaim
	properties (SetAccess=public) 
		targets            = ''
		tracks             = ''
		flightreqs         = struct()
		criterion          = NaN
		gridsatequator     = 200000
		usevalueordering   = true
		split_antimeridian = true
		solution           = ''
		quality            = 0
		path_optimize      = false
		opt_ndir           = 1
		opt_dist           = 25
		opt_niter          = 30000
	end
	methods
		function obj = flaim(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if solution~=FlaimSolutionEnum(), return; end

			md = checkfield(md,'fieldname','flaim.tracks','file',1);
			if any(isnan(md.flaim.criterion)) || isempty(md.flaim.criterion)
				md = checkfield(md,'fieldname','flaim.targets','file',1);
			else
				md = checkfield(md,'fieldname','flaim.criterion','numel',[md.mesh.numberofvertices md.mesh.numberofelements]);
			end

		end % }}}
		function disp(obj) % {{{

			disp(sprintf('   FLAIM - Flight Line Adaptation using Ice sheet Modeling:')); 

			disp(sprintf('\n      Input:'));
			fielddisplay(obj,'targets'            ,'name of kml output targets file ');
			fielddisplay(obj,'tracks'             ,'name of kml input tracks file ');
			fielddisplay(obj,'flightreqs'         ,'structure of kml flight requirements (not used yet)');
			fielddisplay(obj,'criterion'          ,'element or nodal criterion for flight path evaluation (metric)');

			disp(sprintf('\n      Arguments:'));
			fielddisplay(obj,'gridsatequator'     ,'number of grids at equator (determines resolution)');
			fielddisplay(obj,'usevalueordering'   ,'flag to consider target values for flight path evaluation');
			fielddisplay(obj,'split_antimeridian' ,'flag to split polygons on the antimeridian');

			disp(sprintf('\n      Optimization:'));
			fielddisplay(obj,'path_optimize'     ,'optimize? (default false)');
			fielddisplay(obj,'opt_ndir'     ,{'number of directions to test when moving a point.  If this value = 1, a random direction is tested.',...
											  'A value > 1 results in directions equally spaced from [0, 2*PI] being tested.',...
											  'For example, 4 would result in directions [0, PI/2, PI, 3PI/2].'});
			fielddisplay(obj,'opt_dist'     ,'specifies the distance in km (default 25) to move a randomly selected path point on each iteration');
			fielddisplay(obj,'opt_niter'     ,{'number of iterations (default 30,000) to run for flightplan optimization',...
											   'i.e. the number of times to randomly select a point and move it.'});

			disp(sprintf('\n      Output:'));
			fielddisplay(obj,'solution'           ,'name of kml solution file');
			fielddisplay(obj,'quality'            ,'quality of kml solution');
		end % }}}
	end
end
