%SMBhenning Class definition
%
%   Usage:
%      SMBhenning=SMBhenning();

classdef SMBhenning
	properties (SetAccess=public) 
		smbref = NaN;
	end
	methods
		function obj = SMBhenning(varargin) % {{{
			switch nargin
				case 0
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{

			self.smbref=project3d(md,'vector',self.smbref,'type','node');

		end % }}}
		function self = initialize(self,md) % {{{

			if isnan(self.smbref)
				self.smbref=zeros(md.mesh.numberofvertices,1);
				disp('      no surfaceforcings.smbref specified: values set as zero');
			end

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.smbref','forcing',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.smbref','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));
			fielddisplay(obj,'smbref','reference smb from which deviation is calculated [m/yr ice eq]');
		end % }}}
		function marshall(obj,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBhenningEnum(),'format','Integer');
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','smbref','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1);
		end % }}}
	end
end
