/*
 * recast.h
 *
 *  Created on: Jun 26, 2012
 *      Author: utke
 */

#ifndef _RECAST_H_
#define _RECAST_H_

#ifdef HAVE_CONFIG_H
   #include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#if !defined(_HAVE_ADOLC_) || defined(_WRAPPERS_)

template<class To, class From> To reCast(const From& from) {
    return (To)from;
}

#else
#include "./types.h"

template<class To, class From> struct ForPartialSpecialization {
    static  To reCast(const From& from ) { return (To) from;}
};

template<class To, class From> To reCast(const From& from) {
    return ForPartialSpecialization<To,From>::reCast(from);
}
/**
 * partial specialization
 */
template<class To> struct ForPartialSpecialization<To,adouble> {
    static  To reCast(const adouble& from ) { return (To) (from.getValue());}
};

#endif

#endif
