#!/bin/bash
#Synchronize Verbosity
#first remove existing files
rm $ISSM_DIR/src/m/classes/Verb*.m

echo "Synchronizing Verbosity levels..."

#Get all lines of Verbosity.cpp
cat Verbosity.h |  grep "bool Verbose" | awk '{print $2}' | sed -e "s/(/ /" | awk '{print $1}' | awk '{ printf "%s %s\n", NR, $0 }' >temp
#Build header of Verbosity.cpp {{{
cat <<END > Verbosity.cpp
/*
* \file Verbosity.cpp:
* \brief: Manage verbosity levels
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by Synchronize.sh
*            Please read README for more information
*/

/*include*/
/*{{{*/
#ifdef HAVE_CONFIG_H
   #include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "./Verbosity.h"
#include "../Exceptions/exceptions.h"
/*}}}*/

/*Verbosityt levels*/
END
#}}}

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for (( i=1 ; i<=$NUMBEROFLINES ; i++ )); do

	#Get name of the line i
	FILENAME=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}');
	LEVELNAME=$(echo $FILENAME | sed -e "s/Verbose//g");

	let POWER=$i-1
	let BINARY=2**$POWER

	echo "$FILENAME -> 2^$POWER = $BINARY"

	#Add case to verbose.m FIELDS{{{
	if [ $i -eq 1 ]; then cat <<END >> FIELDS
		%BEGINFIELDS
END
fi
	cat <<END >> FIELDS
		$(echo $LEVELNAME | awk {'print tolower($1)'})=false;
END
	if [ $i -eq $NUMBEROFLINES ]; then cat <<END >> FIELDS
		%ENDFIELDS
END
fi
#}}}
	#Add case to verbose.m VERB2BIN{{{
	if [ $i -eq 1 ]; then cat <<END >> VERB2BIN
		%BEGINVERB2BIN
		binary=0;
END
fi
	cat <<END >> VERB2BIN
		if (verbose.$(echo $LEVELNAME | awk {'print tolower($1)'})), binary=bitor(binary,$BINARY); end
END
	if [ $i -eq $NUMBEROFLINES ]; then cat <<END >> VERB2BIN
		%ENDVERB2BIN
END
fi
#}}}
	#Add case to verbose.m BIN2VERB{{{
	if [ $i -eq 1 ]; then cat <<END >> BIN2VERB
		%BEGINBIN2VERB
END
fi
	cat <<END >> BIN2VERB
		if bitand(binary,$BINARY), verbose.$(echo $LEVELNAME | awk {'print tolower($1)'})=true; else verbose.$(echo $LEVELNAME | awk {'print tolower($1)'})=false; end
END
	if [ $i -eq $NUMBEROFLINES ]; then cat <<END >> BIN2VERB
		%ENDBIN2VERB
END
fi
#}}}
	#Add case to verbose.m DISP{{{
	if [ $i -eq 1 ]; then cat <<END >> DISP
		%BEGINDISP
		disp(sprintf('class ''%s''  = ',class(verbose)));
END
fi
	cat <<END >> DISP
		disp(sprintf('   %15s : %s','$(echo $LEVELNAME | awk {'print tolower($1)'})',mat2str(verbose.$(echo $LEVELNAME | awk {'print tolower($1)'}))));
END
	if [ $i -eq $NUMBEROFLINES ]; then cat <<END >> DISP
		%ENDDISP
END
fi
#}}}
	#Add case to Verbosity.cpp {{{
	cat <<END >> Verbosity.cpp
bool $FILENAME(void){return (GetVerbosityLevel() & $BINARY);} /* 2^$POWER*/
END
	#}}}

done

#Add footer of Verbosity.cpp{{{
cat <<END >> Verbosity.cpp

/*Verbosity Setup*/
static int verbositylevel=-1;
/*FUNCTION SetVerbosityLevel {{{*/
void SetVerbosityLevel(int level){

	if(level<0) _error_("vebosity level should be a positive integer (user provided " << level << ")");

	verbositylevel = level;

}/*}}}*/
/*FUNCTION GetVerbosityLevel {{{*/
int  GetVerbosityLevel(void){
	_assert_(verbositylevel>=0);
	return verbositylevel;
}/*}}}*/
END
#}}}
#Complete verbose.m {{{
VERBOSEPATH="$ISSM_DIR/src/m/classes/verbose.m"
cat $VERBOSEPATH  | sed "/%BEGINFIELDS/,$ d"  > temp_begin
cat $VERBOSEPATH  | sed "1,/%ENDFIELDS/d" > temp_end
cat temp_begin FIELDS temp_end > $VERBOSEPATH
rm temp_begin temp_end FIELDS

cat $VERBOSEPATH  | sed "/%BEGINVERB2BIN/,$ d"  > temp_begin
cat $VERBOSEPATH  | sed "1,/%ENDVERB2BIN/d" > temp_end
cat temp_begin VERB2BIN temp_end > $VERBOSEPATH
rm temp_begin temp_end VERB2BIN

cat $VERBOSEPATH  | sed "/%BEGINBIN2VERB/,$ d"  > temp_begin
cat $VERBOSEPATH  | sed "1,/%ENDBIN2VERB/d" > temp_end
cat temp_begin BIN2VERB temp_end > $VERBOSEPATH
rm temp_begin temp_end BIN2VERB

cat $VERBOSEPATH  | sed "/%BEGINDISP/,$ d"  > temp_begin
cat $VERBOSEPATH  | sed "1,/%ENDDISP/d" > temp_end
cat temp_begin DISP temp_end > $VERBOSEPATH
rm temp_begin temp_end DISP
#}}}

#clean up{{{
rm temp
#}}}
