
/*!\file:  SegRef.h
 * \brief abstract class for handling Seg oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 

#ifndef _SEGREF_H_
#define _SEGREF_H_

class GaussSeg;

class SegRef{

	public: 
		int* element_type_list;
		int  element_type;

		SegRef();
		SegRef(const int nummodels);
		~SegRef();

		/*Management*/
		void SetElementType(int type,int type_counter);
		void GetBprimeMasstransport(IssmDouble* Bprime, IssmDouble* xyz_list, GaussSeg* gauss);
		void GetJacobian(IssmDouble* J, IssmDouble* xyz_list,GaussSeg* gauss);
		void GetJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,GaussSeg* gauss);
		void GetJacobianInvert(IssmDouble* Jinv, IssmDouble* xyz_list,GaussSeg* gauss);
		void GetNodalFunctions(IssmDouble* basis,GaussSeg* gauss);
		void GetNodalFunctions(IssmDouble* basis,GaussSeg* gauss,int finiteelement);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list, GaussSeg* gauss);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list, GaussSeg* gauss,int finiteelement);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,GaussSeg* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,GaussSeg* gauss,int finiteelement);
		void GetInputDerivativeValue(IssmDouble* p, IssmDouble* plist,IssmDouble* xyz_list, GaussSeg* gauss);
		void GetInputValue(IssmDouble* p, IssmDouble* plist, GaussSeg* gauss);
		void GetInputValue(IssmDouble* p, IssmDouble* plist, GaussSeg* gauss,int finiteelement);

		int  NumberofNodes(void);
		int  NumberofNodes(int finiteelement);
};
#endif
