#!/bin/bash
set -eu

#Some cleanup
rm -rf install valgrind-3.8.1
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/valgrind-3.8.1.tar.bz2' 'valgrind-3.8.1.tar.bz2'

#Untar 
tar -jxvf  valgrind-3.8.1.tar.bz2

#Move valgrind into install directory
mv valgrind-3.8.1/* install
rm -rf valgrind-3.8.1

#configure
cd install
./configure  --prefix="$ISSM_DIR/externalpackages/valgrind/install" --enable-only32bit

#Compile valgrind
make  -j 4
make install
