#!/bin/bash

#Some cleanup
rm -rf install petsc-3.3-p6 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.3-p6.tar.gz' 'petsc-3.3-p6.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.3-p6.tar.gz
mv petsc-3.3-p6/* src/
rm -rf petsc-3.3-p6

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-mpi-dir=$ISSM_DIR/externalpackages/mpich/install \
 --with-debugging=0 \
 --with-shared-libraries=1 \
 --with-blas-lapack-dir=/opt/intel/mkl/10.0.1.014/ \
 --download-mumps=yes \
 --download-blacs=yes  \
 --download-blas=yes \
 --download-f-blas-lapack=yes \
 --download-scalapack=yes \
 --download-parmetis=yes \
 --download-metis=yes \
 --download-superlu=yes \
 #--download-hypre=yes 

#Compile petsc and install it
make
make install
