#!/bin/bash
set -eu
#Step 1: unzip and install
#Step 2: After Plapack implodes
STEP=0

if [ $STEP -eq 1 ]; then
	#Some cleanup
	rm -rf install petsc-3.1-p7 src
	mkdir install src

	#Download from ISSM server
	$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.1-p7.tar.gz' 'petsc-3.1-p7.tar.gz'

	#Untar and move petsc to install directory
	tar -zxvf  petsc-3.1-p7.tar.gz
	mv petsc-3.1-p7/* install/
	rm -rf petsc-3.1-p7

	#configure
	cd src
	./config/configure.py \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--PETSC_ARCH="$ISSM_ARCH" \
		--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
		--with-debugging=no \
		--with-shared=0 \
		--with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
		--with-mpi-lib=/nasa/sgi/mpt/1.25/lib/libmpi.so \
		--with-mpi-include=/nasa/sgi/mpt/1.25/include  \
		--known-mpi-shared=0 \
		--download-mumps=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--download-plapack=yes \
		--FFLAGS=-I/usr/include \
		--with-cc=icc \
		--with-fc=ifort \
		--COPTFLAGS=" -O3 -xS" \
		--FOPTFLAGS=" -O3 -xS" \
		--CXXOPTFLAGS=" -O3 -xS" \
		--with-pic=1
	echo "== Fix Plapack compilation manually (http://issm.jpl.nasa.gov/installation/compilationtroubleshooting/petsc31/) =="
	echo "== Then run STEP=2 =="
fi
if [ $STEP -eq 2 ]; then
	cd src
	./config/configure.py \
	 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
	 --with-batch=1  \
	 --PETSC_ARCH="$ISSM_ARCH" \
	 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	 --with-debugging=no \
	 --with-shared=0 \
	 --with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
	 --with-mpi-lib=/nasa/sgi/mpt/1.25/lib/libmpi.so \
	 --with-mpi-include=/nasa/sgi/mpt/1.25/include  \
	 --known-mpi-shared=0 \
	 --download-mumps=yes \
	 --download-scalapack=yes \
	 --download-blacs=yes  \
	 --with-plapack-dir=$ISSM_DIR/externalpackages/petsc/src/$ISSM_ARCH \
	 --download-parmetis=yes \
	 --FFLAGS=-I/usr/include \
	 --with-cc=icc \
	 --with-fc=ifort \
	 --COPTFLAGS=" -O3 -xS" \
	 --FOPTFLAGS=" -O3 -xS" \
	 --CXXOPTFLAGS=" -O3 -xS" \
	 --with-pic=1
	echo "== Follow PETSc's instructions"
fi
