from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Pig.exp',35000.)
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp')
md=parameterize(md,'../Par/Pig.py')
md.extrude(3,1.1)
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md.timestepping.time_step=0.
md=solve(md,SteadystateSolutionEnum())

# Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure','Temperature','BasalforcingsGroundediceMeltingRate']
field_tolerances=[5e-08,1.6e-08,5e-08,1.6e-08,1e-09,6e-08,5e-07]
field_values=[\
	md.results.SteadystateSolution.Vx,\
	md.results.SteadystateSolution.Vy,\
	md.results.SteadystateSolution.Vz,\
	md.results.SteadystateSolution.Vel,\
	md.results.SteadystateSolution.Pressure,\
	md.results.SteadystateSolution.Temperature,\
	md.results.SteadystateSolution.BasalforcingsGroundediceMeltingRate,\
	]
