/*!\file: CreateDataSets
 * \brief general driver for creating all datasets that make a finite element model
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "CreateElementsNodesAndMaterials"

#include "./Model.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"


void CreateDataSets(DataSet** pelements,DataSet** pnodes, DataSet** pmaterials, DataSet** pconstraints, DataSet** ploads,DataSet** pparameters,Model* model,ConstDataHandle model_handle){

	/*create parameters common to all solutions: */
	CreateParameters(pparameters,model,model_handle);
	CreateParametersQmu(pparameters,model,model_handle);

	/*This is just a high level driver: */
	if (model->analysis_type==ControlAnalysisEnum()){

		if (model->sub_analysis_type==HorizAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticHoriz(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticHoriz(pconstraints,model,model_handle);
			CreateLoadsDiagnosticHoriz(ploads,model,model_handle);
			CreateParametersControl(pparameters,model,model_handle);

		}
		else if (model->sub_analysis_type==VertAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticVert(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticVert(pconstraints,model,model_handle);
			CreateLoadsDiagnosticVert(ploads,model,model_handle);

		}
		else if (model->sub_analysis_type==StokesAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticStokes(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticStokes(pconstraints,model,model_handle);
			CreateLoadsDiagnosticStokes(ploads,model,model_handle);
			CreateParametersControl(pparameters,model,model_handle);

		}
		else if (model->sub_analysis_type==HutterAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticHutter(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticHutter(pconstraints,model,model_handle);
			CreateLoadsDiagnosticHutter(ploads,model,model_handle);
			CreateParametersControl(pparameters,model,model_handle);

		}

	}
	else if (model->analysis_type==DiagnosticAnalysisEnum()){

		if (model->sub_analysis_type==HorizAnalysisEnum()){
			
			CreateElementsNodesAndMaterialsDiagnosticHoriz(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticHoriz(pconstraints,model,model_handle);
			CreateLoadsDiagnosticHoriz(ploads,model,model_handle);
			CreateParametersDiagnosticHoriz(pparameters,model,model_handle);
				
		}
		else if (model->sub_analysis_type==VertAnalysisEnum()){
		
			CreateElementsNodesAndMaterialsDiagnosticVert(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticVert(pconstraints,model,model_handle);
			CreateLoadsDiagnosticVert(ploads,model,model_handle);
			
		}
		else if (model->sub_analysis_type==StokesAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticStokes(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticStokes(pconstraints,model,model_handle);
			CreateLoadsDiagnosticStokes(ploads,model,model_handle);
			
		}
		else if (model->sub_analysis_type==HutterAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticHutter(pelements,pnodes,pmaterials, model,model_handle);
			CreateConstraintsDiagnosticHutter(pconstraints,model,model_handle);
			CreateLoadsDiagnosticHutter(ploads,model,model_handle);
			
		}
	}
	else if (model->analysis_type==SlopeComputeAnalysisEnum()){

		CreateElementsNodesAndMaterialsSlopeCompute(pelements,pnodes,pmaterials, model,model_handle);
		CreateConstraintsSlopeCompute(pconstraints,model,model_handle);
		CreateLoadsSlopeCompute(ploads,model,model_handle);
	
	}
	else if (model->analysis_type==ThermalAnalysisEnum()){

		CreateElementsNodesAndMaterialsThermal(pelements,pnodes,pmaterials, model,model_handle);
		CreateConstraintsThermal(pconstraints,model,model_handle);
		CreateLoadsThermal(ploads,model,model_handle);
		CreateParametersThermal(pparameters,model,model_handle);
					
	}
	else if (model->analysis_type==MeltingAnalysisEnum()){
			
		CreateElementsNodesAndMaterialsMelting(pelements,pnodes,pmaterials, model,model_handle);
		CreateConstraintsMelting(pconstraints,model,model_handle);
		CreateLoadsMelting(ploads,model,model_handle);
		CreateParametersMelting(pparameters,model,model_handle);
	}
	else if (model->analysis_type==PrognosticAnalysisEnum()){

		CreateElementsNodesAndMaterialsPrognostic(pelements,pnodes,pmaterials, model,model_handle);
		CreateConstraintsPrognostic(pconstraints,model,model_handle);
		CreateLoadsPrognostic(ploads,model,model_handle);
		CreateParametersPrognostic(pparameters,model,model_handle);
					
	}
	else{
		throw ErrorException(__FUNCT__,exprintf("%s%i%s%i%s"," analysis_type: ",model->analysis_type," sub_analysis_type: ",model->sub_analysis_type," not supported yet!"));
	}

			
}
